/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.CharArrayWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.types.URI;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends DeserializerImpl {
    private static final Class[] STRING_STRING_CLASS = new Class[]{String.class, String.class};
    public static final Class[] STRING_CLASS = new Class[]{String.class};
    private final CharArrayWriter val = new CharArrayWriter();
    private Constructor constructor = null;
    private Map propertyMap = null;
    private HashMap attributeMap = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    protected DeserializationContext context = null;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public SimpleDeserializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.init();
    }

    public SimpleDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.init();
    }

    private void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType) && this.typeDesc == null) {
            this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
        }
        if (this.typeDesc != null) {
            this.propertyMap = this.typeDesc.getPropertyDescriptorMap();
        } else {
            BeanPropertyDescriptor[] pd = BeanUtils.getPd(this.javaType, null);
            this.propertyMap = new HashMap();
            for (int i = 0; i < pd.length; ++i) {
                BeanPropertyDescriptor descriptor = pd[i];
                this.propertyMap.put(descriptor.getName(), descriptor);
            }
        }
    }

    public void reset() {
        this.val.reset();
        this.attributeMap = null;
        this.isNil = false;
        this.isEnded = false;
    }

    public void setConstructor(Constructor c) {
        this.constructor = c;
    }

    @Override
    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    @Override
    public void characters(char[] chars, int start, int end) throws SAXException {
        this.val.write(chars, start, end);
    }

    @Override
    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable realException = ite.getTargetException();
            if (realException instanceof Exception) {
                throw new SAXException((Exception)realException);
            }
            throw new SAXException(ite.getMessage());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String source) throws Exception {
        Object value;
        if (this.javaType == String.class) {
            return source;
        }
        if ((source = source.trim()).length() == 0 && this.typeDesc == null) {
            return null;
        }
        if (this.constructor == null && (value = this.makeBasicValue(source)) != null) {
            return value;
        }
        Object[] args = null;
        boolean isQNameSubclass = QName.class.isAssignableFrom(this.javaType);
        if (isQNameSubclass) {
            int colon = source.lastIndexOf(":");
            String namespace = colon < 0 ? "" : this.context.getNamespaceURI(source.substring(0, colon));
            String localPart = colon < 0 ? source : source.substring(colon + 1);
            args = new Object[]{namespace, localPart};
        }
        if (this.constructor == null) {
            try {
                this.constructor = isQNameSubclass ? this.javaType.getDeclaredConstructor(STRING_STRING_CLASS) : this.javaType.getDeclaredConstructor(STRING_CLASS);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.constructor.getParameterTypes().length == 0) {
            try {
                Object obj = this.constructor.newInstance(new Object[0]);
                obj.getClass().getMethod("set_value", String.class).invoke(obj, source);
                return obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (args == null) {
            args = new Object[]{source};
        }
        return this.constructor.newInstance(args);
    }

    private Object makeBasicValue(String source) throws Exception {
        if (this.javaType == Boolean.TYPE || this.javaType == Boolean.class) {
            switch (source.charAt(0)) {
                case '0': 
                case 'F': 
                case 'f': {
                    return Boolean.FALSE;
                }
                case '1': 
                case 'T': 
                case 't': {
                    return Boolean.TRUE;
                }
            }
            throw new NumberFormatException(Messages.getMessage("badBool00"));
        }
        if (this.javaType == Float.TYPE || this.javaType == Float.class) {
            if (source.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (source.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            return new Float(source);
        }
        if (this.javaType == Double.TYPE || this.javaType == Double.class) {
            if (source.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (source.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            return new Double(source);
        }
        if (this.javaType == Integer.TYPE || this.javaType == Integer.class) {
            return new Integer(source);
        }
        if (this.javaType == Short.TYPE || this.javaType == Short.class) {
            return new Short(source);
        }
        if (this.javaType == Long.TYPE || this.javaType == Long.class) {
            return new Long(source);
        }
        if (this.javaType == Byte.TYPE || this.javaType == Byte.class) {
            return new Byte(source);
        }
        if (this.javaType == URI.class) {
            return new URI(source);
        }
        return null;
    }

    @Override
    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        this.context = context;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Class type;
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = attributes.getLocalName(i);
            if (this.typeDesc != null && (fieldName = this.typeDesc.getFieldNameForAttribute(attrQName)) == null || this.propertyMap == null || (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) == null || !bpd.isWriteable() || bpd.isIndexed()) continue;
            TypeMapping tm = context.getTypeMapping();
            QName qn = tm.getTypeQName(type = bpd.getType());
            if (qn == null) {
                throw new SAXException(Messages.getMessage("unregistered00", type.toString()));
            }
            Deserializer dSer = context.getDeserializerForType(qn);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage("noDeser00", type.toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
            }
            if (this.attributeMap == null) {
                this.attributeMap = new HashMap();
            }
            try {
                Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                this.attributeMap.put(fieldName, val);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        if (this.attributeMap == null) {
            return;
        }
        Set entries = this.attributeMap.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object val = entry.getValue();
            BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(name);
            if (!bpd.isWriteable() || bpd.isIndexed()) continue;
            try {
                bpd.set(this.value, val);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }
}

