/*
 * Decompiled with CFR 0.152.
 */
package com.sonus.ems.lawfulintercept.liTarget.api.test;

import com.sonus.ems.lawfulintercept.ws.bind.LawfulInterceptTargetServiceSOAPBindingStub;
import com.sonus.ems.lawfulintercept.ws.model.EnabledEnum;
import com.sonus.ems.lawfulintercept.ws.model.ForwardedCallInterceptEnum;
import com.sonus.ems.lawfulintercept.ws.model.InterceptCriteriaTypeEnum;
import com.sonus.ems.lawfulintercept.ws.model.LawfulInterceptTarget;
import com.sonus.ems.lawfulintercept.ws.model.LawfulInterceptTargetApiException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TestLIAPI
extends TestCase {
    protected static ResourceBundle DATA_CATALOG = null;
    public static String mainUrl = new String("/liTargetProvisioning/services/");
    public LawfulInterceptTargetServiceSOAPBindingStub liApi = null;

    public TestLIAPI(String name) {
        super(name);
    }

    protected void setUp() {
        String hostname = DATA_CATALOG.getString("data.apiHostname");
        String port = DATA_CATALOG.getString("data.apiPort");
        String username = DATA_CATALOG.getString("data.apiUsername");
        String password = DATA_CATALOG.getString("data.apiPassword");
        try {
            SOAPHeaderElement user = new SOAPHeaderElement("", "USER");
            if (username == null) {
                user.setObjectValue((Object)"calea");
            } else {
                user.setObjectValue((Object)username);
            }
            SOAPHeaderElement passwd = new SOAPHeaderElement("", "PASSWORD");
            if (password == null) {
                passwd.setObjectValue((Object)"calea");
            } else {
                passwd.setObjectValue((Object)password);
            }
            this.liApi = new LawfulInterceptTargetServiceSOAPBindingStub(this.makeUrl(hostname, port, "LawfulInterceptTargetService"), null);
            this.liApi.setHeader(user);
            this.liApi.setHeader(passwd);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in locating the LI services " + e));
        }
        Logger log = Logger.getLogger((String)"org.apache.axis");
        log.setLevel(Level.OFF);
    }

    public void testTargetCreateDN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.DirectoryNo);
        liTarget.setInterceptCriteriaId("1\\9781231234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            TestLIAPI.assertTrue((String)"Retrieved LI target's ForwardedCallIntercept value is not equal to created value.", (boolean)liTargetb.getForwardedCallIntercept().getValue().equals(ForwardedCallInterceptEnum.True.getValue()));
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to created liTarget value.", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.True.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetCreate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetCreate" + e));
        }
    }

    public void testTargetUpdateDN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.DirectoryNo);
        liTarget.setInterceptCriteriaId("1\\9781231234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            liTargetb.setEnabled(EnabledEnum.False);
            this.liApi.updateLawfulInterceptTarget(liTargetb);
            LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Updated LI target not retrieved successfully. Potention problem with target updation.", (Object)liTargetc);
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to updated target value. Potention problme with updation", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.False.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetUpdate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetUpdate" + e));
        }
    }

    public void testListLawfulInterceptTargetDN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.DirectoryNo);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget[] list1 = this.liApi.listLawfulInterceptTarget();
            int prevSize = list1.length;
            liTarget.setInterceptCriteriaId("1\\9781235555");
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget[] list = this.liApi.listLawfulInterceptTarget();
            TestLIAPI.assertEquals((String)"Retrieve LI targets count does not match create count", (int)(prevSize + 1), (int)list.length);
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget" + e));
        }
    }

    public void testTargetDeleteDN1() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.DirectoryNo);
        liTarget.setInterceptCriteriaId("1\\9781231234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetDeleteDN2() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.DirectoryNo);
        liTarget.setInterceptCriteriaId("1\\9781235555");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetCreateBgVPN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BusinessGroup_PrivateVPNNum);
        liTarget.setInterceptCriteriaId("Sonus Networks\\\\Westford\\1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            TestLIAPI.assertTrue((String)"Retrieved LI target's ForwardedCallIntercept value is not equal to created value.", (boolean)liTargetb.getForwardedCallIntercept().getValue().equals(ForwardedCallInterceptEnum.True.getValue()));
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to created liTarget value.", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.True.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetCreate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetCreate" + e));
        }
    }

    public void testTargetUpdateBgVPN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BusinessGroup_PrivateVPNNum);
        liTarget.setInterceptCriteriaId("Sonus Networks\\\\Westford\\1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            liTargetb.setEnabled(EnabledEnum.False);
            this.liApi.updateLawfulInterceptTarget(liTargetb);
            LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Updated LI target not retrieved successfully. Potention problem with target updation.", (Object)liTargetc);
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to updated target value. Potention problme with updation", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.False.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetUpdate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetUpdate" + e));
        }
    }

    public void testListLawfulInterceptTargetBgVPN() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BusinessGroup_PrivateVPNNum);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget[] list1 = this.liApi.listLawfulInterceptTarget();
            int prevSize = list1.length;
            liTarget.setInterceptCriteriaId("Sonus Networks\\\\Westford\\5555");
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget[] list = this.liApi.listLawfulInterceptTarget();
            TestLIAPI.assertEquals((String)"Retrieve LI targets count does not match create count", (int)(prevSize + 1), (int)list.length);
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget" + e));
        }
    }

    public void testTargetDeleteBgVPN1() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BusinessGroup_PrivateVPNNum);
        liTarget.setInterceptCriteriaId("Sonus Networks\\\\Westford\\1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetDeleteBgVPN2() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BusinessGroup_PrivateVPNNum);
        liTarget.setInterceptCriteriaId("Sonus Networks\\\\Westford\\5555");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetCreateSIPURI() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.SIP_URI);
        liTarget.setInterceptCriteriaId("sip:support@10.6.20.158:1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            TestLIAPI.assertTrue((String)"Retrieved LI target's ForwardedCallIntercept value is not equal to created value.", (boolean)liTargetb.getForwardedCallIntercept().getValue().equals(ForwardedCallInterceptEnum.True.getValue()));
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to created liTarget value.", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.True.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetCreate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetCreate" + e));
        }
    }

    public void testTargetUpdateSIPURI() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.SIP_URI);
        liTarget.setInterceptCriteriaId("sip:support@10.6.20.158:1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            liTargetb.setEnabled(EnabledEnum.False);
            this.liApi.updateLawfulInterceptTarget(liTargetb);
            LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Updated LI target not retrieved successfully. Potention problem with target updation.", (Object)liTargetc);
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to updated target value. Potention problme with updation", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.False.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetUpdate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetUpdate" + e));
        }
    }

    public void testListLawfulInterceptTargetSIPURI() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.SIP_URI);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget[] list1 = this.liApi.listLawfulInterceptTarget();
            int prevSize = list1.length;
            liTarget.setInterceptCriteriaId("sip:support@10.6.20.158:5555");
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget[] list = this.liApi.listLawfulInterceptTarget();
            TestLIAPI.assertEquals((String)"Retrieve LI targets count does not match create count", (int)(prevSize + 1), (int)list.length);
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget" + e));
        }
    }

    public void testTargetDeleteSIPURI1() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.SIP_URI);
        liTarget.setInterceptCriteriaId("sip:support@10.6.20.158:1234");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetDeleteSIPURI2() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.SIP_URI);
        liTarget.setInterceptCriteriaId("sip:support@10.6.20.158:5555");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetCreateBillingNum() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BillingNum);
        liTarget.setInterceptCriteriaId("1\\9781238881");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            TestLIAPI.assertTrue((String)"Retrieved LI target's ForwardedCallIntercept value is not equal to created value.", (boolean)liTargetb.getForwardedCallIntercept().getValue().equals(ForwardedCallInterceptEnum.True.getValue()));
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to created liTarget value.", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.True.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetCreate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetCreate" + e));
        }
    }

    public void testTargetUpdateBillingNum() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BillingNum);
        liTarget.setInterceptCriteriaId("1\\9781238881");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            liTargetb.setEnabled(EnabledEnum.False);
            this.liApi.updateLawfulInterceptTarget(liTargetb);
            LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Updated LI target not retrieved successfully. Potention problem with target updation.", (Object)liTargetc);
            TestLIAPI.assertTrue((String)"Retrieved LI Target Enabled flag is not equal to updated target value. Potention problme with updation", (boolean)liTargetb.getEnabled().getValue().equals(EnabledEnum.False.getValue()));
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetUpdate, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetUpdate" + e));
        }
    }

    public void testListLawfulInterceptTargetBillingNum() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BillingNum);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget[] list1 = this.liApi.listLawfulInterceptTarget();
            int prevSize = list1.length;
            liTarget.setInterceptCriteriaId("1\\9781238885");
            this.liApi.createLawfulInterceptTarget(liTarget);
            LawfulInterceptTarget[] list = this.liApi.listLawfulInterceptTarget();
            TestLIAPI.assertEquals((String)"Retrieve LI targets count does not match create count", (int)(prevSize + 1), (int)list.length);
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testListLawfulInterceptTarget" + e));
        }
    }

    public void testTargetDeleteBillingNum1() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BillingNum);
        liTarget.setInterceptCriteriaId("1\\9781238881");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    public void testTargetDeleteBillingNum2() {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.BillingNum);
        liTarget.setInterceptCriteriaId("1\\9781238885");
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.True);
        liTarget.setEnabled(EnabledEnum.True);
        try {
            LawfulInterceptTarget liTargetb = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            TestLIAPI.assertNotNull((String)"Created LI target not retrieved successfully. Potention problem with target creation.", (Object)liTargetb);
            this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            try {
                LawfulInterceptTarget liTargetc = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
                TestLIAPI.fail((String)"Delete LI Target failed.");
            }
            catch (LawfulInterceptTargetApiException lawfulInterceptTargetApiException) {}
        }
        catch (LawfulInterceptTargetApiException e) {
            TestLIAPI.fail((String)("Exception in testTargetDelete, @error_message=" + e.getErrorMessage() + " @error_code =" + e.getErrorCode()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in testTargetDelete" + e));
        }
    }

    protected void tearDown() {
    }

    public URL makeUrl(String hostname, String port, String serviceName) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append(hostname);
        sb.append(":");
        sb.append(port);
        sb.append(mainUrl);
        sb.append(serviceName);
        String urlStr = sb.toString();
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            TestLIAPI.fail((String)("Exception in forming the URL " + e));
        }
        return url;
    }

    public static void main(String[] args) {
        TestLIAPI instance = new TestLIAPI("");
        TestRunner.run(((Object)((Object)instance)).getClass());
    }

    static {
        try {
            DATA_CATALOG = ResourceBundle.getBundle("com.sonus.ems.lawfulintercept.liTarget.api.test.LIData");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

