#!/bin/bash

# determine the directory I reside in
PROG_DIR=$(cd $(dirname ${BASH_SOURCE[0]}) && pwd)

#############################################################################
######## provide variables/functions that config validation requires ########
#############################################################################

# repave utility is for loadding SWe machines
hostType="ConnexIP5000"

# resultFile is passed to trapExit in validateConfig, repave doesn't use it
resultFile=""

# logfile is passed as first argument to logMsg. repave utility
# does not use a log. in case that changes lets use something we
# can search for.
logFile="UNSET"

# no support for debug interfaces
dbgInterfaceCfg="n"

# validate the packet interface configuration
pktInterfaceCfg="y"

# mimic what commandVariables provide
AWK="/usr/bin/awk"
BASH="/bin/bash"
CAT="/bin/cat"
ECHO="/bin/echo"
GETCONF="/usr/bin/getconf"
GREP="/bin/grep"
HOST_TYPE="/etc/hostType"

# expect script looks for these messages
ERROR_MSG="Config file validation failed!"

# provide the exit function called from the validation function
# upon a validation failure
trapExit()
{
    echo $ERROR_MSG
    exit $1
}

# log a message to both stdout and a log file: prints time stamp also
# don't put the timestamp on stdout....
# param 1: log file
# param 2: the message to log
# NOTE: a log file name of UNSET means that we should NOT write to
# the log file...
logMsg()
{
    local logFile=$1
    local logMsg=${@:2}

    dateStr=`date +"%b %d %T.%3N %Y"`
    echo -e "$dateStr: $logMsg"

    if [ "$logFile" != "UNSET" ]; then
       echo -e "$dateStr: $logMsg" >> $logFile
    fi
}

#################################
######## main processing ########
#################################

# source validation helpers
source $PROG_DIR/commonCfgValidation.sh
source $PROG_DIR/cfgValidation.sh

# make sure we have the permissions we need
chmod +x $PROG_DIR/validateV6addr

# read the config file in order to validate it
source "$1"

# validate the configuration
validateConfig

# success
exit 0
