#!/bin/bash

# Test if an IPv4 address is valid:
# Usage:
#    valid_ip IP_ADDRESS
#    if [[ $? -eq 0 ]]; then good; else bad; fi
# OR
#    if valid_ip IP_ADDRESS; then good; else bad; fi
#
function valid_ip()
{
   local  ip=$1
   local  stat=1

   if [[ $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
      OIFS="${IFS}"
      IFS=".\n"
      ip=($ip)
      IFS="${OIFS}"
      [[ ${ip[0]} != '' && ${ip[1]} != '' \
         && ${ip[2]} != '' && ${ip[3]} != '' \
         && ${ip[0]} -le 255 && ${ip[1]} -le 255 \
         && ${ip[2]} -le 255 && ${ip[3]} -le 255 \
         && ${ip[0]} -ge 0 && ${ip[1]} -ge 0 \
         && ${ip[2]} -ge 0 && ${ip[3]} -ge 0 ]]
      stat=$?
   fi
   return $stat
}

# Test if an IPv6 IP address is valid
function valid_ipv6()
{
	local ip=$1
	local stat=0

    local progPath="/opt/sonus/bin"
    if [[ ! -f $progPath/validateV6addr ]]; then
       progPath=$(cd $(dirname ${BASH_SOURCE[0]}) && pwd)
    fi

	if $progPath/validateV6addr $1; then
	   stat=1
    fi
	return $stat
}

function getPrefix()
{
  local tmpOct=$1
  local octPrefix=$2
  while [ $tmpOct -ne 0 ]
  do
    # Below logic is to avoid holes with in an octet
    # e.g. 192 is 1100 0000 and prefix shall be 2
    #      193 is 1100 0001 in which case prefix shall still be 2
    local msbit=$((tmpOct&128)) # 128 = 0x80 to check for the MSB
    if [ $msbit -eq 0 ]; then
      break
    fi

    tmpOct=$((tmpOct<<1))
    tmpOct=$((tmpOct&255)) # truncate to octect
    octPrefix=$((octPrefix+1))
  done

  eval ${3}=$octPrefix
}

function convNetmaskToNetprefix()
{
  local mask=$1
  local echoRes=${2-0}

  gPrefix=0

  oct1=`$ECHO $mask | $AWK -F. '{print $1}'`
  oct2=`$ECHO $mask | $AWK -F. '{print $2}'`
  oct3=`$ECHO $mask | $AWK -F. '{print $3}'`
  oct4=`$ECHO $mask | $AWK -F. '{print $4}'`

  # Avoid holes across octets
  # if we see 254.255.255.0
  # prefix conversion for that shall be 7 without which
  # prefix logic won't work
  getPrefix $oct1 $gPrefix gPrefix
  if [ $gPrefix -eq 8 ]; then
    getPrefix $oct2 $gPrefix gPrefix
  fi
  if [ $gPrefix -eq 16 ]; then
    getPrefix $oct3 $gPrefix gPrefix
  fi
  if [ $gPrefix -eq 24 ]; then
    getPrefix $oct4 $gPrefix gPrefix
  fi

  if [ $echoRes -eq 1 ]; then
      $ECHO $gPrefix
  else
      return $gPrefix
  fi
}
