#!/usr/bin/env python3
import io
import sys
import shutil
import os
import csv
import time
import re
import subprocess
try:
    from ruamel.yaml import YAML
except ModuleNotFoundError:
    print("ruamel.yaml not found. Setting up virtual environment...")

    # Create virtual environment
    subprocess.run(["virtualenv", "-p", "/usr/bin/python3", ".python_venv_test"])

    # Install ruamel.yaml using the venv's pip
    pip_path = ".python_venv_test/bin/pip"
    subprocess.run([pip_path, "install", "ruamel.yaml"])

    # Now try importing again
    activate_this = ".python_venv_test/bin/activate_this.py"
    with open(activate_this) as f:
        exec(f.read(), {'__file__': activate_this})

    from ruamel.yaml import YAML


debug = False

def log (msg):
    if debug == True:
        print(msg)


def checkTypeAndUpdateAttribute(yDict, last_field, value, attrType, attrName):
    if not last_field in yDict.keys():
        log("Warning: Inserting Key '" + last_field + "' to '" + attrName + "' with a value '" + value + "'")
        yDict[last_field] = value

    elif isinstance(yDict[last_field], list) or attrType == "list":
        yDict[last_field].clear()
        yDict[last_field] = yaml.load(value)
    elif isinstance(yDict[last_field], dict) or attrType == "dict":
        yDict[last_field].clear()
        yDict[last_field] = yaml.load(value)
    elif attrType == "bool":
        if value.lower() == "true":
            yDict[last_field] = True
        else:
            yDict[last_field] = False
    elif attrType == "int":
        yDict[last_field] = int(value)
    elif attrType == "float":
        yDict[last_field] = float(value)
    elif attrType.lower() != "unknown" and value.lower != "none":
        yDict[last_field] = str(value)

"""
Updates the values.yaml with the value against each of the metadata mentioned in the CSV file.
The inputs are values.yaml and a line from CSV at a time. It splits the atribute with "."(dot)
seperated intoi list of nested fields. Checks each line of values.yaml file against each nested
field starting from first nested field. When nested field is found, checks for next nested field
and continues. When last nested field reached, replaces its value.
"""
def update_yaml_file(loadedYaml, file_name, field_updates, attrType):

    updated = False

    # build list of nested fields
    for field, value in field_updates.items():
        nested_fields = field.split('.')
        
    value = value.strip()
    if value == "":
        log("Warning: Value is not set to update for '" + field + "'")
        #value = None
        #return

    yDict = loadedYaml
    pos = 0
    for nested_field in nested_fields[:-1]:
        try:
            yDict = yDict[nested_field]
            pos += 1
        except:
            #check for special case like "prometheus.io/port"
            nft = nested_field 
            for nf in nested_fields[pos+1:]:
                nft += "." + nf 
            checkTypeAndUpdateAttribute(yDict, nft, value, attrType, field)
            log("Attribute: '" + field + " is updated with '" + value + "'") 
            return
    try:
        checkTypeAndUpdateAttribute(yDict,nested_fields[-1], value, attrType, field)
        log("Attribute: '" + field + " is updated with '" + value + "'") 
    except Exception as e:
        log(e)
        log("warning: Unable to update the value for '" + field + "'!!!!...") 
    return

def buildValue (line, beginChar, endChar):
    value = line[1]
    if line[1].startswith(beginChar) :
        for partValue in line[2:]:
            log (partValue)
            value += "," + partValue.strip()
            if ( partValue.endswith(endChar) ):
                break
    return value



if __name__ == '__main__':
    # Parse command-line arguments
    if len(sys.argv) < 3:
        print ("Usage: python3 script.py <values file name> <csv file>")
        print ("Note: Use python3 or above version")
        print ("")
        sys.exit(1)

    file_name = sys.argv[1]
    field_updates = {}

    #if not file_name.writeable():
    if not os.access(file_name, os.W_OK):
        log("Warning: " + file_name + " is not writeable, please provide write permission and re-run")
        sys.exit(1)

    backupFile = file_name + ".bk." + str(time.time())
    if (os.path.exists(backupFile)):
        if (input(backupFile + " backup file already exists, Do you want to overwrite and continue?<Y/N>")).lower() != 'y':
            sys.exit(1)

    log(" Taking the backup of " + file_name + " in " + backupFile )

    shutil.copy(file_name, backupFile)

    yaml = YAML()
    with open(file_name, 'r') as stream:
        try:
            loadedYaml = yaml.load(stream)
        except yaml.YAMLError as exc:
            print(exc)
            sys.exit(1)

        stream.close()


    try:
        with open(sys.argv[2], mode ='r') as file:
            csvFile = csv.reader(file)
            heading = next(csvFile)
            for line in csvFile:
                if len(line) >= 3:
                    line[1].strip()
                    # Update the YAML file for each config
                    field_updates[line[0]] = line[1]
                    update_yaml_file(loadedYaml, file_name, field_updates, line[2])
                elif len(line) == 1:
                    log(str("Warning: " + line[0]) + " is incomplete")
            file.close()
    except Exception as e:
        log(e)
        log("Error occured, file unchanged")
        shutil.copy(backupFile, file_name)

    with open(file_name, 'w') as stream:
        try:
            data = yaml.dump(loadedYaml, stream)
        except yaml.YAMLError as exc:
            log(exc)
            sys.exit(1)

    stream.close()

