#!/usr/bin/env python
import sys
import csv
import os
import subprocess
try:
    from ruamel.yaml import YAML
    from ruamel.yaml.comments import CommentedMap, CommentedSeq
except ModuleNotFoundError:
    print("ruamel.yaml not found. Setting up virtual environment...")

    # Create virtual environment
    subprocess.run(["virtualenv", "-p", "/usr/bin/python3", ".python_venv_test"])

    # Install ruamel.yaml using the venv's pip
    pip_path = ".python_venv_test/bin/pip"
    subprocess.run([pip_path, "install", "ruamel.yaml"])

    # Now try importing again
    activate_this = ".python_venv_test/bin/activate_this.py"
    with open(activate_this) as f:
        exec(f.read(), {'__file__': activate_this})

    from ruamel.yaml import YAML
    from ruamel.yaml.comments import CommentedMap, CommentedSeq

# set attributes
def get_comments_map(self, key):
    coms = []
    comments = self.ca.items.get(key)
    if comments is None:
        return coms
    for token in comments:
        if token is None:
            continue
        elif isinstance(token, list):
            coms.extend(token)
        else:
            coms.append(token)
    return coms

def get_comments_seq(self, idx):
    coms = []
    comments = self.ca.items.get(idx)
    if comments is None:
        return coms
    for token in comments:
        if token is None:
            continue
        elif isinstance(token, list):
            coms.extend(token)
        else:
            coms.append(token)
    return coms

setattr(CommentedMap, 'get_comments', get_comments_map)
setattr(CommentedSeq, 'get_comments', get_comments_seq)

def getComments (yDict):
    if isinstance(yDict, CommentedMap):
        commentsStr = ""
        for k, v in yDict.items():
            for comment in yDict.get_comments(k):
                commentsStr += comment.value[:-1]
    elif isinstance(yDict, CommentedSeq):
        commentsStr = ""
        for idx, item in enumerate(data):
            for comment in data.get_comments(idx):
                commentsStr += comment.value[:-1]
    commentsStr = commentsStr.replace("\n", "\t ") 
    return commentsStr

def addRowInCsv(stream, attrName, value, comments):
    if isinstance(value, dict):
        typeOfVal = "dict"
    elif isinstance(value, list):
        typeOfVal = "list"
    elif (value == True or value == False):
        if(str(value) == "0" or str(value) == "1"):
            typeOfVal = "int"
        else:
            typeOfVal = "bool"
    elif isinstance(value, int):
        typeOfVal = "int"
    elif isinstance(value, float):
        typeOfVal = "float"
    elif (value == None) or str(value).lower() == "none":
        typeOfVal = "unknown"
        value = ""
    elif isinstance(value, str):
        typeOfVal = "str"
    else:
        typeOfVal = "scalar"
    row = []
    row.append(attrName)
    row.append(value)
    row.append(typeOfVal)
    #row.append(comments) #issue with comments, so do not add now
    row.append("")
    stream.writerow(row)

    

# Recursively called until the last index in the dictionary hiearchy
def traverseDict( yDict, inStr, stream):
    global commentsWritten
    global prevComments
    for key in yDict:

        inStr1 = inStr + "." + key
        value = yDict[key]
        try:
            traverseDict(yDict[key], inStr1, stream)

            #if this is last element in the dictionary with no value, write this attribute to csv.

            if yDict[key] == ""  or (len (yDict[key]) == 0) or isinstance(yDict[key], list):
                commentsStr = getComments(yDict)
                addRowInCsv(stream, inStr1, yDict[key], commentsStr)
                 
        except Exception as e:

            # Reached here as we can't index any more into dictionary
            # yDict[key] could be integer, list or list of dictionaries ..

            #last indexing in dictionary hiearchy, write into csv.

            commentsStr = getComments(yDict)
            addRowInCsv(stream, inStr1, yDict[key], commentsStr)


if __name__ == '__main__':
    # Parse command-line arguments
    if len(sys.argv) < 3:
        print("Usage: python3 script.py <values file name> <output csv file>")
        print("")
        sys.exit(1)

    file_name = sys.argv[1]

    print("Loading : " + file_name)
    yaml = YAML()
    with open(file_name, 'r') as stream:
        try:
            loaded = yaml.load(stream )
        except yaml.YAMLError as exc:
            print(exc)
            sys.exit(1)

        stream.close()


    csvFile = sys.argv[2]
    #build the attribute list
    with open(csvFile, 'w', newline='') as stream:
        csvwriter = csv.writer(stream, delimiter=',' , quotechar='"', quoting=csv.QUOTE_MINIMAL)
        #Add the table header
        header = ['Attribute Name', 'Attribute Value', 'type','comments']
        csvwriter.writerow(header)

        try:
            for i in loaded:
                traverseDict(loaded[i], i, csvwriter)

        except yaml.YAMLError as exc:
            print(exc)
        stream.close()
    print ("Atributes saved in " + csvFile)
