import os
import setuptools

version = os.environ.get('ORCA_VERSION') + '.' + os.environ.get('BUILD_NUMBER', 'devxxx')
version = version.replace('\\', '').replace('"', '').replace('\'', '')

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="createConfigDrive",
    version=version,
    author="Harish Ramachandrappa",
    author_email="hramachandrappa@rbbn.com",
    description="The CLI utility to create configdrive for KVM Qcow2 and Vmware vmdk installation.",
    long_description=long_description,
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=2.7',
    install_requires=[
        'netaddr',
    ],
)
