#!/bin/bash
#
source /opt/sonus/bin/sonusCommonUtils.sh
source /opt/sonus/sbx/scripts/sonusUtils.sh

operation="Gluster fs mount check"
result="success"
reason="none"
exitCode=0

printLog()
{
    timeOfTheDay=`$DATE +'%a %b %e %H:%M:%S %Z %Y'`
    `$ECHO -e "$timeOfTheDay : $1" >> $SWE_CLI_CONF_LOG_FILE`
}

mode=$(getApplicationType)

function mountGlusterFsCheck()
{
    if $MOUNT | $GREP $SONUS_CONFIG_STORE_DIR > /dev/null; then
        printLog "Gluster fs mounted. Proceed forward."
    else
        printLog "Gluster fs not mounted. return..."
        return 1
    fi
    return 0
}

function mountGlusterFsTest()
{
    if [[ "$mode" == "oam" ]]; then
        mountGlusterFsCheck
        retCode=$?
        if [[ $retCode -ne 0 ]]; then
            result="failure"
            reason="Gluster fs mount check fails"
            exitCode=1
        fi
    fi
}

mountGlusterFsTest

echo "Operation: $operation"
echo "Result: $result"
echo "Reason: $reason"

exit $exitCode
