#!/bin/bash
#
source /opt/sonus/bin/sonusCommonUtils.sh

logFile="/var/log/glusterfs/mnt-gfsvol1.log"
operation="Gluster TLS pre upgrade procedure"
result="success"
reason="none"
exitCode=0

mode=`$CAT $ETC_APPLICATION`
currentRole=`$PYTHON3 /opt/sonus/sbx/serf/serfGetSelfParams.py currentRole`

function glusterTlsOAMActiveNode()
{
    if [[ "$mode" == "oam" ]]; then
       if [ "$currentRole" == "active" ]; then
             gluster volume set gvol1 client.ssl on >/dev/null
             gluster volume set gvol1 server.ssl on >/dev/null
             gluster volume set gvol1 ssl.certificate-depth 2 >/dev/null
             output=`echo y | gluster volume stop gvol1`
             if echo "$output" | grep -q "volume stop: gvol1: success"; then
                     gluster volume start gvol1 >/dev/null
             fi
       fi
    fi
}

glusterTlsOAMActiveNode
umount /mnt/gfsvol1
$GLUSTER_SETUP_SH -m

$GREP "SSL verification succeeded" $logFile >/dev/null
   if [ $? != 0 ] ; then
      result="failure"
      reason="Gluster TLS fails"
      exitCode=1
   fi

echo "Operation: $operation"
echo "Result: $result"
echo "Reason: $reason"

exit $exitCode
