#!/bin/bash

#############################################################
#
# Copyright (c) 2013 Sonus Networks, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# Module Description: 
#    Script to retrieve peer ip address
#    return ip address
#      
#      
#############################################################

# Sourcing Command Variables
if [ -e /opt/sonus/staging/sonusCommands.sh ]
then
    source /opt/sonus/staging/sonusCommands.sh
elif [ -e /opt/sonus/bin/sonusCommands.sh ]
then
    source /opt/sonus/bin/sonusCommands.sh
else
    /bin/echo "Could not locate sonusCommands.sh Exiting..."
    exit 1
fi

if [ -e /opt/sonus/staging/sonusCommonFiles.sh ]
then
    source /opt/sonus/staging/sonusCommonFiles.sh
elif [ -e /opt/sonus/bin/sonusCommonFiles.sh ]
then
    source /opt/sonus/bin/sonusCommonFiles.sh
else
    $ECHO "Could not locate sonusCommonFiles.sh Exiting..."
    exit 1
fi

# pickup some common utilities
if [ -f $STAGING_SONUS_UTILS_SH ]; then
   . $STAGING_SONUS_UTILS_SH
else
   . $SONUS_UTILS_SH
fi

hostTypeFile=$HOST_TYPE
hostType=Unknown
hostSubType=Unknown

if [ -e $hostTypeFile ]; then
    hostType=`$CAT $hostTypeFile`
fi

if [ -e $HOST_SUB_TYPE ]; then
    hostSubType=`$CAT $HOST_SUB_TYPE`
fi

# Backward compatibility
sbxConfFile=$SBXCONF_FILE
if [ ! -e $sbxConfFile ];then
   sbxConfFile="/opt/sonus/sbx.conf"
fi

if [[ $hostType == "ConnexIP5000" ]]; then
    if [[ "$hostSubType" == "virtualContainer" ]]; then
        if [[ $INTER_POD_NET_FAMILY == "v6" ]]; then
            tmpPeerServer=`$_IP -brief -6 addr show dev $INTER_POD_COMMUNICATION_INTF scope global  2> /dev/null | $AWK '{print $3}' | $AWK -F/ '{print $1}'`
        else
            tmpPeerServer=$(getIpAddr $INTER_POD_COMMUNICATION_INTF)
        fi
    else
        tmpPeerServer=$(getIpAddr ha0)
    fi
    activeServer=`$GREP activePrimaryInterCeIpaddr $sbxConfFile | $AWK -F\= '{print $2}'`
    standbyServer=`$GREP standbyPrimaryInterCeIpaddr $sbxConfFile | $AWK -F\= '{print $2}'`
    if [[ $tmpPeerServer == $activeServer ]]; then
        peerAddr=$standbyServer
    elif [[ $tmpPeerServer == $standbyServer ]]; then
        peerAddr=$activeServer
    else
        $ECHO -e " Could not resolve peer connection for Swe"
        exit 1
    fi
else
    tmpPeerServer=$(getIpAddr bond0)
    if [[ $tmpPeerServer == "169.254.99.1" ]]; then
        peerAddr="169.254.88.1"
    elif [[ $tmpPeerServer == "169.254.88.1" ]]; then
        peerAddr="169.254.99.1"
    else
        $ECHO -e " Could not resolve peer connection"
        exit 1
    fi
fi

$ECHO "ADDR:$peerAddr"
exit 0
