#!/usr/bin/perl -w

#
#
# This script needs below packages:
# libio-stty-perl_0.03-1_all.deb
# libio-pty-perl_1.08-1+b2_amd64.deb
# libexpect-perl_1.21-1_all.deb
#
#

BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/staging");
}

use lib '/opt/sonus/bin';
use lib "/opt/sonus/staging";
use sonusCommands;
use lib "/opt/sonus/installUpgrade/";
use sbxCommonFunctions;
no warnings 'once';

my $packageInstalled =  eval { require Expect };
if ( ! defined($packageInstalled) )
{
  # DO NOT put any type of log or print statement here.
  # This is a normal/expected path when upgrading from pre-5.1 releases, and
  # any output will flood the upgrade log.
  exit(0);
}
else
{
  require sbxPeerExpectUtils;
}

use strict;
use FileHandle;
use Getopt::Std;
use Switch;
use IO::Socket::INET;
use Term::ANSIColor;
use Cwd;
use File::Basename;
my $remoteLog="/var/log/remoteExecution.log";

my $ceName=sbxCommonFunctions::getInstalledceName();
my $peerCeName=sbxCommonFunctions::getInstalledpeerCeName();

my $gLogCommandOutput  = 0;

sub main
{
    my $cmd= shift;
    my $misc = shift;
    # print("My cmd=$cmd,my misc=$misc\n");
    sbxPeerExpectUtils::logMsg("Starting main()");
    my $gDebServer=$peerCeName;
    if ( $misc =~ /cli/)
    {
      my $role=sbxCommonFunctions::getCurrentRole("self");
      if( $role =~ /active/)
      {
        $gDebServer=$ceName;
      }
    }
    my $shellHandle = "";
    $shellHandle = sbxPeerExpectUtils::connectToShell($gDebServer, "2024" );
    if ($shellHandle =~ /failure/)
    {
        sbxPeerExpectUtils::logMsg("Unable to login to shell...shellHandle=$shellHandle");
        exit(2);
    }
    printf("\n\n");
    sbxPeerExpectUtils::logMsg("Running command on remote host=$gDebServer, Command='$cmd'");
    my ($ret, $out) = "";

    if( $misc =~ /cli/)
    {
       ($ret, $out) = sbxPeerExpectUtils::executeCliCommand($shellHandle, "$cmd");
    }
    else
    {
      ($ret, $out) = sbxPeerExpectUtils::executeCommand($shellHandle, "$cmd");
    }
    my @result = split("\n", $out);
    sbxPeerExpectUtils::logMsg("Result: @result");
}

my $fun = "unknown";
my $miscArg = "unknown";

if( $ARGV[0] ne "" )
{
  $fun = $ARGV[0];
  chomp($fun);
}
if( $ARGV[1] ne "" )
{
  $miscArg = $ARGV[1];
  chomp($miscArg);
}
main( $fun,$miscArg);

exit(0);
