#!/usr/bin/perl -w
##############################################################
###
### Copyright (c) 2019 Ribbon Communication, Inc.
###
### All Rights Reserved.
### Confidential and Proprietary.
###
### checkLicenseStatus.pl
### 15 Jan 2020.
###
### Module Description:
###
### This script contains utilities to be used during VNFC
### automated software upgrade process.
###
###
### This script doesn't contain main() and shouldn't be invoked on it's own.
###
###############################################################
BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/staging");
}
use strict;
use warnings;

use sonusCommands;
use sonusCommonFiles;
use Time::Piece;

my $licenseCmd="show table system licenseInfo | csv";
my $operation="license status check";
my $result="success";
my $reason="none";
my $exitCode=0;

sub sbcCheckLicenseInfo
{
    my $status ="SUCCESS";
    my @out=`($SLEEP 1; $ECHO -e "set screen width 512\n $licenseCmd \n") | $SUDO /opt/sonus/sbx/tailf/bin/confd_cli -u admin --noaaa --noninteractive | $TAIL -n+4`;

    my @value;
    my %feature_hash;

    foreach (@out){
        my @out_values = split(',', $_);
        my @features = ( $out_values[2], $out_values[3]);
        @{$feature_hash{$out_values[0]}}= @features;
    }

    for (keys %feature_hash) {
         my @array_value = @{$feature_hash{$_}};
         if ((defined $array_value[0] && length $array_value[0] > 0 ) && (defined $array_value[1] && length $array_value[1] > 0))
         {
              my $dateformat = "%Y-%m-%d-%H:%M";
              my $licenseDate;
              my $currentTime=localtime;

              $licenseDate = Time::Piece->strptime($array_value[0],$dateformat);
              if($currentTime->julian_day > $licenseDate->julian_day )
              {
                  $status = "FAIL";
              }
         }
         else
         {
             #$reason = "license is not installed";
         }
   }
   return $status;
}

sub checkLicensePostUpgrade()
{
    my $nodeLicenseStatus = sbcCheckLicenseInfo();
    if ( "FAIL" eq $nodeLicenseStatus )
    {
         $result = "failure";
         $reason = "license is not valid";
         $exitCode = 1;
    }
}

checkLicensePostUpgrade();
print "Operation: $operation\n";
print "Result: $result\n";
print "Reason: $reason\n";
exit $exitCode;

