#!/bin/bash

###############################################################
# This script extract existing version and target version
# information and checks if they are compatible according to LSWU matrix
###############################################################

# Sourcing Command Variables
source /opt/sonus/bin/sonusCommands.sh
source /opt/sonus/bin/sonusCommonFiles.sh

scriptDir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

operation="Upgrade version compatibility check"
result="success"
reason="none"
exitCode=0

currentVersion=`$SWINFO_SH -l | $GREP "SBC:   " | $AWK '{print $2}' | $SED 's/-//'`
targetVersion=`$GREP "SBC Version:" $scriptDir/.buildinfo | $AWK '{print $3}'| $SED 's/-//'`

output=$($scriptDir/checkLswu -f $currentVersion -t $targetVersion -m $scriptDir)

if [ $? -ne 0 ]; then
    result="failure"
    reason=${output}
    exitCode=1
fi

echo "Operation: $operation"
echo "Result: $result"
echo "Reason: $reason"

exit $exitCode

