#!/bin/bash


logFile='/var/log/sonus/config_vlan.log'
usage()
{
   echo "Only options are $0 start|config|done|stop|help"
   echo "Example : enable_vlan.sh config <interface> <vlanid>"
 
}

function start()
{
   chkconfig sfips-post off
   chkconfig cloud-final off
   chkconfig cloud-config off
   chkconfig cps off
   chkconfig cloud-init off
   chkconfig cloud-init-local off
   chkconfig lca off
   sync
   reboot 
}

function config_vlan()
{
   local interface=$1
   local vlan=$2
   ip link set $interface up
   #vconfig add $interface $vlan
   ip link add link $interface name $interface.$vlan type vlan id $vlan
   ip link set $interface.$vlan up
}

function complete()
{
   reboot
}

function stop()
{
   chkconfig lca on
   chkconfig cloud-init-local on
   chkconfig cloud-init on
   chkconfig cps on
   chkconfig cloud-config on
   chkconfig cloud-final on
   chkconfig sfips-post on
   sync
   reboot 
}
function main()
{
   echo "$0 START: `date +'%a %b %e %H:%M:%S %Z %Y'`" >> $logFile
   local opt=$1
   case "$opt" in
      start)
         echo "$0 `date +'%a %b %e %H:%M:%S %Z %Y'`: Start called...." >> $logFile
         start
         ;;
      config)
         echo "$0 `date +'%a %b %e %H:%M:%S %Z %Y'`: Config called.... for $1 with vlan $2" >> $logFile
         if [ "$#" -ne 3 ]; then
            usage
            exit
         fi
         config_vlan $2 $3
         ;;
      done)
         echo "$0 `date +'%a %b %e %H:%M:%S %Z %Y'`: Done called...." >> $logFile
         complete
         ;;
      stop)
         echo "$0 `date +'%a %b %e %H:%M:%S %Z %Y'`: Stop called...." >> $logFile
         stop
         ;;
      help)
         usage
         ;;
      ?)
         usage
         ;;
      *) 
         usage
         ;;
   esac
   echo "$0 END: `date +'%a %b %e %H:%M:%S %Z %Y'`" >> $logFile
}

main $1 $2 $3
