#!/usr/bin/perl
#############################################################
#
# Copyright (c) 2025 Ribbon Communications, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# Module Description:
#    Script to remove localServer from /system/policyServer
#    from sonusPolicyServer.xml seeded data xml file
#
#############################################################
BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/sbx/scripts");
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/staging");
}
no warnings 'once';
use strict;
use sonusCommands;
use sonusCommonFiles;
use Getopt::Std;

my $cdbXmlPath = "$SONUS_TAILF_CDB_DIR";
my $progname=`$BASENAME $0`;
chomp($progname);

sub removeLocalServerFromPolicyInit()
{
  my $message = <<'END_MESSAGE';
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="http://sonusnet.com/ns/mibs/SONUS-POLICY-SERVER/1.0" >
 <xsl:output omit-xml-declaration="yes"/>
    <xsl:template match="node()|@*">
      <xsl:copy>
         <xsl:apply-templates select="node()|@*"/>
      </xsl:copy>
    </xsl:template>
<xsl:template match="a:localServer"></xsl:template>
</xsl:stylesheet>
END_MESSAGE

  $message =~ s/\n//g;
  my $filename= "${cdbXmlPath}/sonusPolicyServer.xml";
  my $cmd = "$ECHO \'$message\' | $XSLTPROC -o $filename.tmp - $filename";
  `$cmd`;
  if ($? != 0)
  {
    `$LOGGER -t $progname "Could not remove localServer element from $filename"`;
  }
  else
  {
    `$MV $filename.tmp $filename`;
  }
}

sub main()
{
  removeLocalServerFromPolicyInit();
}

main();
exit(0);
