#!/bin/bash
#############################################################
#
# Copyright (c) 2015 Sonus Networks, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# Module Description:
# Script to copy the OS files to temporary boot OS
# so that on next boot original root (/) partition
# can be resized/split to 3 partitions P1(root1), P2(root2), P3(/home/common)
#
#############################################################

# Sourcing Command Variables
sonusCommonUtils="/opt/sonus/staging/sonusCommonUtils.sh"
if [ -e $sonusCommonUtils ]; then
   source $sonusCommonUtils 
else
   sonusCommonUtils="/opt/sonus/bin/sonusCommonUtils.sh"
   if [ -e $sonusCommonUtils ];then
      source $sonusCommonUtils 
   else
      /bin/echo "Could not locate sonusCommonUtils.sh Exiting..."
      exit 1 
   fi
fi
sonusCommonCfgValidation="$(dirname $sonusCommonUtils)/commonCfgValidation.sh"

sonusCommands="/opt/sonus/staging/sonusCommands.sh"
if [ ! -e $sonusCommands ];then
    sonusCommands="/opt/sonus/bin/sonusCommands.sh"
fi

sonusCommonFiles="/opt/sonus/staging/sonusCommonFiles.sh"
if [ ! -e $sonusCommonFiles ];then
    sonusCommonFiles="/opt/sonus/bin/sonusCommonFiles.sh"
fi

sonusStaging=$SONUS_STAGING_DIR
drbdConfFile=$ETC_DRBD_CONF
tempOSdir=/tmp/tmpOS
partitionTool=$PARTITION_TOOL_SH
dest=$1

if [ -z "$1" ];then
 dest=${primary_disk}7
fi

# Check if required files are present
if [ ! -e $partitionTool ]; then
   $ECHO "$partitionTool doesn't exists! Exiting.."
   exit 1
fi

# Backup boot images
# create a temporary directory to mount the /dev/sda
$MKDIR -p $tempOSdir
$LS $ETC_INITD_SBX &>/dev/null
if [ "$dest" == "${primary_disk}7" ]; then

   # use sfdisk to swap the partition 
   $SFDISK -d $primary_device > ~/$primary_disk.bkp
   $CP ~/sda.bkp ~/sda1.bkp
   
   $UMOUNT ${primary_device}7
   
   $SED -e "/${primary_disk}7/s/Id=82/Id=83/" -i  ~/${primary_disk}1.bkp
   $SLEEP 1
   $SFDISK -f $primary_device < ~/${primary_disk}1.bkp
             
   $SLEEP 1  
   # make aware the kernel about the changes
   $PARTPROBE 
   $SLEEP 1 
   $MKFS ${primary_device}7
     
   temp=$($FDISK -l $primary_device | $GREP ${primary_disk}7 | $AWK '{print $5}');
   if [ $temp != 83 ]; then
      $ECHO "Partition table not modified successfully . Exiting .."
      exit 1;
   fi           
   
else
    $UMOUNT ${primary_device}6
fi

$MOUNT /dev/$dest $tempOSdir

$MOUNT | $GREP $tempOSdir | $GREP -q -v grep
if [ $? -ne 0 ]; then
   $ECHO "Could not mount $dest to $tempOSdir. Exiting.."
   exit 1;
fi

$CP -af `$LS -d /*|$EGREP -v "proc|root|tmp|lost|home|opt|var|usr|*.log"` $tempOSdir 2>/dev/null

$MKDIR -p $tempOSdir/opt/sonus/bin $tempOSdir/home $tempOSdir/root $tempOSdir/tmp $tempOSdir/proc $tempOSdir/usr $tempOSdir/usr/bin  $tempOSdir/var $tempOSdir/var/log $tempOSdir/var/lib 
$TOUCH $tempOSdir/var/log/messages 

$LS $ETC_INITD_SBX &>/dev/null
if [ $? -eq 0 ]; then
   $TOUCH $tempOSdir/tmp/sbxApp
fi 

$CP -af `$LS -d /usr/* | $EGREP -v "/usr/share"` $tempOSdir/usr/ 2>/dev/null
$MKDIR -p $tempOSdir/usr/share/perl
$CP -af /usr/share/perl/* $tempOSdir/usr/share/perl 2>/dev/null
$MKDIR -p $tempOSdir/usr/share/grub
$CP -af /usr/share/grub/* $tempOSdir/usr/share/grub 2>/dev/null

$CP -af `$LS -d /var/* | $EGREP -v "/var/lib|/var/log"` $tempOSdir/var 2>/dev/null

$CP -af `$LS -d /var/lib/* | $EGREP -v "/var/lib/libvirt"` $tempOSdir/var/lib 2>/dev/null

# Files needed in the temp boot partition while partitioning
$CP -f $sonusCommands    $tempOSdir/opt/sonus/bin/
$CP -f $sonusCommonFiles $tempOSdir/opt/sonus/bin/
$CP -f $sonusCommonUtils $tempOSdir/opt/sonus/bin/
$CP -f $sonusCommonCfgValidation $tempOSdir/opt/sonus/bin/

# Remove unwanted services from running during partitioning
# note: some on this list are from watching solssh to see what was
# being started during boot for partitioning
# note: auditd and apache2 are disabled since they are not needed
# and they also were failing to start anyway.  redirect stderr
# since there is a complaint about failing to read /proc/cmdline
chrootSystemctl $tempOSdir mask sbx.service
chrootSystemctl $tempOSdir mask sfips-post.service
$CHROOT $tempOSdir $UPDATE_RC_D -f monit remove
$CHROOT $tempOSdir $UPDATE_RC_D -f libvirt-bin remove
$CHROOT $tempOSdir $UPDATE_RC_D -f cron remove
chrootSystemctl $tempOSdir mask sbxbond.service
chrootSystemctl $tempOSdir mask cps.service
$CHROOT $tempOSdir $UPDATE_RC_D -f ipmievd remove
chrootSystemctl $tempOSdir mask installcnxipm.service
chrootSystemctl $tempOSdir mask sbxirqbalance.service
chrootSystemctl $tempOSdir mask sonusInitdSystemDSync.service
chrootSystemctl $tempOSdir mask checkbonding.service
chrootSystemctl $tempOSdir mask sbxcgroups.service
chrootSystemctl $tempOSdir mask sbxPerf.service
chrootSystemctl $tempOSdir mask chs.service
$CHROOT $tempOSdir $UPDATE_RC_D -f ssh remove
chrootSystemctl $tempOSdir mask auditd.service
chrootSystemctl $tempOSdir mask apache2.service
chrootSystemctl $tempOSdir mask dbus.service
chrootSystemctl $tempOSdir mask cloud-final.service
chrootSystemctl $tempOSdir mask cloud-config.service
chrootSystemctl $tempOSdir mask cloud-init.service
chrootSystemctl $tempOSdir mask cloud-init-local.service

# Setup script which does partitioning, chmod script to 755
$CHMOD 0755 $tempOSdir/$partitionTool
$SED -i "s,^exit,$partitionTool start \n&," $tempOSdir/etc/rc.local

# Modify fstab 
$SED -i -e "s/\/dev\/mapper\/debian-root/\/dev\/$dest/" $tempOSdir/etc/fstab
$SED -i -e '/evlog/ s/^#*/#/' $tempOSdir/etc/fstab
$SED -i -e '/${primary_disk}7/{n; s/^#*/#/}' $tempOSdir/etc/fstab

if [ "$dest" == "${primary_disk}7" ]; then 
   local ifaceExists=$(checkIface bond0)
   if [ $ifaceExists -eq 0 ]; then
      oldIp=$(getIpAddr bond0)
      newIp="127.0.0.1"
      $SED -i -e "s/$oldIp/$newIp/g" $tempOSdir$ETC_DRBD_CONF
   fi
   $SED -i -e '/connect-int/s/5/120/' $tempOSdir$ETC_DRBD_CONF
fi 

# Keep track of temporary OS contents. These need to be deleted after re-partitioning.

#Setup proper timezone on temp OS
timezone=`$READLINK /etc/localtime`
if [ "$timezone" != "" ]; then
   $CP --parents $timezone $tempOSdir/
fi


if [ "$dest" == "${primary_disk}6" ]; then
  $CP $HOST_TYPE $tempOSdir/hostType
  $ECHO "mounted ${primary_disk}6" > $tempOSdir/root/bootSda6
else
  $ECHO "mounted ${primary_disk}7" > $tempOSdir/root/bootSda7
fi

cd $sonusStaging
$UMOUNT $tempOSdir 
$E2FSCK -y -f /dev/$dest 
