package sbxCommonFunctions;
#
# This script defines some common functions 
# which are utilized by different perl scripts.
#

use strict;
use Exporter;
use sonusCommands;

# sonusCommonFiles cannot be used here
# as this file maybe accessed during upgrade from 
# ealier release where sonusCommonFiles is not available.
# Provide similar variables here to reduce confusion and keep from someone
# including it.
my $SERVICE_SH="/opt/sonus/sbx/scripts/service.sh";
my $ETC_INITD_SBX="/etc/init.d/sbx";
$ETC_INITD_SBX="/opt/sonus/etc/init.d/sbx" if (! -e $ETC_INITD_SBX);
my $SONUS_PEER_CNX_EXPECT="/opt/sonus/sbx/scripts/sonusPeerCnx.expect";

# Getting Primary device and primary disk
our $primary_disk = `$GREP -vE '.\*\[0\-9\]\$' /proc/partitions|$GREP -v major|$GREP -vE \^\$| $AWK '{print \$4}' | $SORT | $HEAD -n1`;
chomp $primary_disk;
if ( $primary_disk eq '' )
{
    # On AWS NVMe volumes the disk is /dev/nvme0n1
    $primary_disk = `$GREP "nvme" /proc/partitions | $GREP -vE "p\[0\-9\]\$" | $GREP -v major|$GREP -vE \^\$| $AWK '{print \$4}'`;
    chomp $primary_disk;
}
our $primary_device = '/dev/' . $primary_disk;

our @EXPORT_OK = qw(getInstalledceName getInstalledpeerCeName getInstalledRole getCurrentRole archiveUMLogFiles);

my $sbxConfigFile;
if ( -e "/opt/sonus/conf/sbx.conf" )
{
  $sbxConfigFile="/opt/sonus/conf/sbx.conf";
}
elsif ( -e "/opt/sonus/sbx.conf" )
{
  $sbxConfigFile="/opt/sonus/sbx.conf";
}
else
{
  print("Failed to find sbx.conf file");
}

my $upgradeBaseDir="/var/log/sonus/upgrade";
my $upgradeDir="$upgradeBaseDir/current";
my $upgradeCheckDir="$upgradeBaseDir/preChecks";

sub getInstalledceName
{
  my $ceName="connexip";

  if ( -e $sbxConfigFile )
  {
     $ceName=`$GREP ceName $sbxConfigFile | $AWK -F "="  '{print \$2}'`;
     chomp($ceName);
  }
  return($ceName);
}

sub getInstalledpeerCeName
{
  my $peerCeName="unknown";

  if ( -e $sbxConfigFile )
  {
     $peerCeName=`$GREP peerCeName $sbxConfigFile | $AWK -F "="  '{print \$2}'`;
     chomp($peerCeName);
  }
  return($peerCeName);
}

sub getInstalledRole
{
  my $role="1";
  if ( -e $sbxConfigFile )
  {
     $role=`$GREP role $sbxConfigFile |$AWK -F "="  '{print \$2}' |$AWK '{print \$1}'`;
     chomp($role);
  }
  return($role);
}

sub getCurrentRole
{
  my $server=shift;
  my $status="unknown";
  if ($server =~ /self/)
  {
    if ( -e "$SERVICE_SH" )
    {
        $status=`$SUDO $SERVICE_SH sbx status |$GREP "Service running"`; # sudoers-sonusadmin
    }
    else
    {
        $status=`$SUDO $ETC_INITD_SBX status |$GREP "Service running"`; # sudoers-legacy
    }
  }
  elsif($server =~ /peer/)
  {
    $status=`$SONUS_PEER_CNX_EXPECT $SUDO $SERVICE_SH sbx status |$GREP "Service running"`; # sudoers-cnxipmadmin
  }
  chomp($status);
  if ( defined($status) && $status ne "")
  {
    my ($status1,$status2)= split('\[', $status);
    ($status,$status1)= split('\]', $status2);
  }
  else
  {
    $status = "unassigned";
  }
  return($status);
}

#########################################################################
# archiveLogFiles: Archives status and log files, removes tokens.
#########################################################################
sub archiveUMLogFiles
{
  my $timeStamp=`$DATE +%Y_%m_%d_%H_%M_%S`;
  chomp($timeStamp);
  my $dirCheck=`$SONUS_PEER_CNX_EXPECT $LS -d $upgradeDir`;
  if ( $dirCheck !~ /No such file or directory/ )
  {
    print("Archiving status and log Files on peer server..\n");

    `$SONUS_PEER_CNX_EXPECT $MKDIR -p $upgradeBaseDir/history`;
    `$SONUS_PEER_CNX_EXPECT $MV $upgradeDir $upgradeBaseDir/history/logs_$timeStamp`;
    `$SONUS_PEER_CNX_EXPECT $CP -f $upgradeCheckDir/* $upgradeBaseDir/history/logs_$timeStamp`;
    `$SONUS_PEER_CNX_EXPECT $MV -f $upgradeBaseDir/statusUpdater.log $upgradeBaseDir/history/logs_$timeStamp`;
    `$SONUS_PEER_CNX_EXPECT $RM -f $upgradeBaseDir/latest`;
    `$SONUS_PEER_CNX_EXPECT $LN -s history/logs_$timeStamp $upgradeBaseDir/latest`;
  }
  $dirCheck=`$LS -d $upgradeDir`;
  if ( $dirCheck !~ /No such file or directory/ )
  {
    print("Archiving status and log Files on current server..\n");
    `$MKDIR -p $upgradeBaseDir/history`;
    `$MV $upgradeDir $upgradeBaseDir/history/logs_$timeStamp`;
    `$CP -f $upgradeCheckDir/* $upgradeBaseDir/history/logs_$timeStamp`;
    `$MV -f $upgradeBaseDir/statusUpdater.log $upgradeBaseDir/history/logs_$timeStamp`;
    `$RM -f $upgradeBaseDir/latest`;
    `$LN -s $upgradeBaseDir/history/logs_$timeStamp $upgradeBaseDir/latest`;
  }
}

1;

