package sbxPeerExpectUtils;
#
#
#This script needs below packages:
#libio-stty-perl_0.03-1_all.deb
#libio-pty-perl_1.08-1+b2_amd64.deb
#libexpect-perl_1.21-1_all.deb
#
#

use strict;
use FileHandle;
use Getopt::Std;
use Switch;
use IO::Socket::INET;
use Expect;
use Term::ANSIColor;
use Cwd;
use File::Basename;
use sonusCommands;
use sonusCommonFiles;
use sbxCommonFunctions;
use Exporter;

our @EXPORT_OK = qw(logMsg connectToShell executeCommand executeCliCommand runCliCommand);

my $remoteLog="/var/log/remoteExecution.log";
my $gShellPrompt   = "~\$";
my $gShellUserName = "cnxipmadmin";
open BUILDLOG, '>', $remoteLog;
chmod 0640, $remoteLog;

my $ceName=sbxCommonFunctions::getInstalledceName();
my $peerCeName=sbxCommonFunctions::getInstalledpeerCeName();

my $gLogCommandOutput  = 1;

sub logMsg
{
  my $message = shift;
  my $dateStr=`$DATE +"%b %d %T"`;
  chomp($dateStr);

  #print(STDOUT "$dateStr: $message\n");
  print(BUILDLOG "$dateStr: $message\n");
}

sub convert_time
{
  my $time = shift;
  my $hours = int($time / 3600);
  $time -= ($hours * 3600);
  my $minutes = int($time / 60);
  my $seconds = $time % 60;

  $hours = $hours < 1 ? '' : $hours;
  $minutes = $minutes < 1 ? '' : $minutes;
  $time = sprintf("%02sh:%02sm:%02ss", $hours, $minutes, $seconds);
  return $time;
}

sub connectToShell
{
  my $host = shift;
  my $port = shift;
  my $handle;
  my $timeout = 60;

  sbxPeerExpectUtils::logMsg("Connecting to $host...");

  my $exp = new Expect;
  $exp->raw_pty(1);
  $handle = $exp->spawn("$SSH -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null -p $port $gShellUserName\@$host");

  #$handle->debug(2);

  $handle->log_stdout(0);

  #sbxPeerExpectUtils::logMsg("===> gShellPrompt: $gShellPrompt");

  # set to default password in case we are running in an older release
  # that does not have encryptedStore.
  my $password = "Cnx1PmAdm1n";
  if ( -x "$ENCRYPTED_STORE_SH" )
  {
    $password =`$ENCRYPTED_STORE_SH cnxipmadmin`;
  }

  chomp($password);

  $handle->expect($timeout,
                  [ qr/yes/i, sub { $handle->send("yes\n");
                                      exp_continue; }],
                  [ qr/assword: /i, sub {
                  #  set status [ catch { set password [exec $ENCRYPTED_STORE_SH cnxipmadmin] } msg ];
                  #  if { "$status" != "0" } {
                  #      # Hardcoded password for backward compatibility
                  #      set password "Cnx1PmAdm1n";
                  #  }
                    $handle->send("$password\n");
                    exp_continue; }],
                  $gShellPrompt) || return "failure";

  return( $handle );
}

sub executeCliCommand
{
  my $handle = shift;
  my $cmd = shift;
  my $buffer = "";
  my $ret = "success";
  ($ret, $buffer) = executeCommand($handle, "\($SLEEP 1; $ECHO -e \"set screen width 512\\n $cmd \\n\"\) | $SUDO $CONFD_CLI -u admin --noaaa --noninteractive"); # sudoers-cnxipmadmin
  return ($ret, $buffer);
}

sub executeCommand
{
  my $handle = shift;
  my $command = shift;
  my $timeout = shift;
  my $expect = $gShellPrompt; # shift;
  my $buffer = "";
  my $ret = "success";

  if (!$timeout || $timeout == 0)
  {
    $timeout = 60;
  }

  sbxPeerExpectUtils::logMsg("Executing Command: $command, timeout: $timeout");

  $handle->clear_accum();
  $handle->send("$command\n");
  if (!($handle->expect($timeout,
                        [ qr/yes\/no/i, sub { $handle->send("yes\n");
                                      exp_continue; }],
                        [ qr/y\/n/i, sub { $handle->send("y\n");
                                      exp_continue; }],
                        [ qr/ontinuous/i, sub { $handle->send("c");
                                      exp_continue; }],
                        [ qr/sudo\] password for cnxipmadmin:/i, sub { exit; }],
                        $expect)))
  {
    $ret = "failure";
  }

  $buffer = $handle->before();

  # Copy the output into array and get rid of line (prompt) and add a newline
  # Split and join are done so that we get uniform output even if the last line doesn't contain \n
  my @bufferArray = split(/\n/, $buffer);
  my $buffer2 = join("\n", @bufferArray);
  $buffer2 .= "\n";

  $handle->clear_accum();

  if ($gLogCommandOutput == 1)
  {
    sbxPeerExpectUtils::logMsg($buffer2);
  }

  return ($ret, $buffer2);
}

sub runCliCommand
{
  my $shellHandle = shift;
  my $cmd = shift;
  my $out;
  my $ret;
  my $role=sbxCommonFunctions::getCurrentRole("self");
  if( $role =~ /active/)
  {
    $out=`($SLEEP 1; $ECHO -e "set screen width 512\n $cmd \n") | $SUDO $CONFD_CLI -u admin --noaaa --noninteractive`; # sudoers-cnxipmadmin
  }
  else
  {
    ($ret, $out) = executeCliCommand($shellHandle, "$cmd");
  }
  return($out);
}

1;

