#!/bin/bash

#######################################################################################################
#  This script checks for the modification in file permission , file owner and group after upgrading  # 
#  from one version to another version. It saves the modifications in a file .                        # 
#######################################################################################################

if [ -e /opt/sonus/staging/sonusCommonUtils.sh ]; then
    source /opt/sonus/staging/sonusCommonUtils.sh
elif [ -e /opt/sonus/bin/sonusCommonUtils.sh ]; then
    source /opt/sonus/bin/sonusCommonUtils.sh
else
    /bin/echo "Could not locate sonusCommonUtils.sh Exiting..."
fi

if [ -e /opt/sonus/staging/sonusUtils.sh ];then
    . /opt/sonus/staging/sonusUtils.sh
elif [ -e $SONUS_UTILS_SH ];then
    . $SONUS_UTILS_SH
else
    $ECHO "Could not find /opt/sonus/staging/sonusUtils.sh or $SONUS_UTILS_SH .Exiting ...."
    exit 1
fi
    
function usage(){

    $ECHO "This script needs proper parameter to run"
    $ECHO "beforeUpgrade ---> To run this script before upgrade"
    $ECHO "afterUpgrade  ---> To run this script after upgrade"
    $ECHO "manualRun     ---> To run this script for sysdump"

}

if [ $# -lt 1 ]; then
    usage
    exit 1
fi



if [[ ! -d /var/log/permission ]]; then
    $MKDIR /var/log/permission
fi

isDebPkgMgmt
if [ $? -ne 0 ]; then
  currentVersion=`$RPM -qa |$GREP sbc |$AWK -F "sbc-" '{print $2}' |$SED 's/.x86_64.*//'`
else
  currentVersion=$($DPKG -l sbc | $GREP ^ii | $AWK '{ print $3 }' |$SED 's/^/V/')
fi
  
logDir="/var/log/permission"
permissionOld="$logDir/permission_$currentVersion_old"
permissionNew="$logDir/permission_$currentVersion"
file1="$logDir/file1"
file2="$logDir/file2"
logFile="$stagingDir/permissionCheck.log" 


#This function stores all the permissions in a file.
function getPermissions() {

    logMsg $logFile "Current version $currentVersion"
    if [[ -e $permissionOld ]]; then
        $RM -f $permissionNew
    else
        if [[ -e $permissionNew ]]; then
            $MV $permissionNew $permissionOld 
        fi
    fi

    $FIND / -maxdepth 100 \! -type l -type d \( -path /proc -o -path /tmp -o -path /var/log  -o -path /home/sftproot/log -o -path /dev -o -path /home/log -o -path /mnt/target/dev  \) -prune -o -print | xargs ls -ld 2>/dev/null | $AWK '{print$9,$1,$3,$4}' | $GREP -v "\[" | LC_ALL=C $SORT > $permissionNew

    logMsg $logFile "permission file filled with data"

}

#This function checks for the change in permissions for files after upgrade.
function compare() {

    if [[ $currentVersion != $versionSupplied ]]; then
        logMsg $logFile "Started comparing"
        diffFile="$logDir/permission_${versionSupplied}_${currentVersion}.diff" 
        logMsg $logFile "diffFile $diffFile created"

        #Checks whether diffFile Exists already and delete the diffFile.
        if [ -e $diffFile ]; then
            $RM -f $diffFile
            $TOUCH $diffFile
        fi

        logMsg $logFile "Diff result of version $versionSupplied and $currentVersion"
        compareFile="$logDir/permission_$versionSupplied"
        logMsg $logFile "comparing $compareFile with $permissionNew"

        if [[ -e $compareFile ]]; then
            $DIFF $compareFile $permissionNew | $GREP "<"|$SED 's/<//' >$file1
            $DIFF $compareFile $permissionNew | $GREP ">"|$SED 's/>//' >$file2

            while read input
            do
                nameold=`$ECHO $input |$AWK '{print$1}'`
                permold=`$ECHO $input |$AWK '{print$2}'`
                ownerold=`$ECHO $input |$AWK '{print$3}'`
                groupold=`$ECHO $input |$AWK '{print$4}'`
                var=`$GREP "$nameold " $file2`

                if [[ -n $var ]]; then
                    permnew=`$ECHO $var | $AWK '{print $2}'`
                    ownernew=`$ECHO $var | $AWK '{print $3}'` 
                    groupnew=`$ECHO $var | $AWK '{print $4}'`

                    if [[ $permold != $permnew || $ownerold != $ownernew || $groupold != $groupnew ]]; then
                        $ECHO "$nameold">>$diffFile
                        $ECHO "$versionSupplied $permold $ownerold $groupold">>$diffFile
                        $ECHO "$currentVersion $permnew $ownernew $groupnew">>$diffFile  
                        $ECHO "">>$diffFile
                        #Stores the records which are differing in permissions in a file named diffFile
                    fi
                fi
            done<$file1
        fi 
    fi

    logMsg $logFile "Finished writing to $diffFile"

}

#Real execution of script based on supplied parameter.

if [ $1 == "beforeUpgrade" ]; then
    logMsg $logFile "Running the permissionCheck.sh before upgrade"
    getPermissions
    $ECHO $currentVersion > $logDir/permission.version
elif [ $1 == "afterUpgrade" ]; then
    logMsg $logFile "Running the permissionCheck.sh after upgrade"
    getPermissions
    if [ -e $logDir/permission.version ]; then
        versionSupplied=`$CAT $logDir/permission.version` 
        compare
    else
        logMsg $logFile "Could not find $logDir/permission.version file to get the version to comapare"
        exit 1
    fi
elif [ $1 == "manualRun" ]; then
    logMsg $logFile "Running the permissionCheck.sh for sysdump"
    timeStamp=`$DATE '+%Y_%m_%d_%H_%M_%S'`
    permissionNew=$logDir/permission_$timeStamp
    getPermissions
else
    usage
fi


#Removing non-useful files

$RM -f $file1 $file2 
