#!/usr/bin/perl -w

#############################################################
#
# Copyright (c) 2009 Sonus Networks, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# sbxTargetUpgrade.pl
#
# Gautham Nimmagadda
# 02/10/09
#
# Module Description:
#
# NOTE: THIS SCRIPT IS NOT TESTED AGAINST DEVELOPMENT MACHINE
#
# This script drives upgrade process to upgrade a running SBX
# This script is invoked from System Manager (SM) process
# and walks the machine on which it is invoked through 
# required LSWU steps. Uses utilities from sbx(Target)UpgradeRevertUtils.pl
#
# This script is copied to SBX tar.gz as sbxUpgrade.pl
#
# TBD: check errors from fcopy() and dircopy()
#############################################################

BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/staging");
}

use lib "/opt/sonus/staging"; # This is where the scripts live
no warnings 'once';

use sonusCommands;
use sonusCommonFiles;
use sbxCommonFunctions;

require "sbxUpgradeUtils.pl";

my $progname=`$BASENAME $0`;
my $gRole="unknown";         # indicates if upgrading active/standby etc
my $gPackage="unknown";      # Package to install
my $gDebName="unknown";      # Name of the Deb, could be different from package name
my $time = "unknown";
my $status = "unknown";

# Upgrade functionality broken out so that info read from ModuleProcessNames.pm
# will be from the new package and not the currently loaded version
my $statusUpdater="$STATUS_UPDATER_PL";
# These Dirs are already created as part of preInstall Checks
my $upgradeBaseDir="$SONUS_LOG_UPGRADE_DIR";
my $upgradeStatusFile="$SOFTWARE_UPGRADE_STATUS";

my $sonusStaging="$SONUS_STAGING_DIR";                          
my $sbxUpgradeLogFile="$UPGRADE_OUT";     # Log file to be used for SBX upgrade
my $origMajorVersion=5;                   # flag came into being with version 5.0
my $hostType=`$CAT $HOST_TYPE`;
chomp($hostType);
my $hostSubType=`$CAT $HOST_SUB_TYPE 2> /dev/null`;  # might not exist depending on LSWU path
chomp($hostSubType);

# Revert feature related files
if( ! -d "$HOME_COMMON/")
{
  mkdir("$HOME_COMMON/");
}
my $p2sbxUpgradeCommand=join(' ', $0, @ARGV, "-q");
my $pmMarkerFile="$SBX_INSTALL_UPGRADE_TXT";
my $dbUpgradeMarker="$DB_UPGRADE_MARKER";
my $pre50MarkerFile="$PRE50_MARKER_TXT";

my $DoDUpgradeMarker="/home/admin/DoDUpgradeMarker";

my $sbxImageUpgrader="$SBX_IMAGE_BASED_UPGRADE_SH";
my $sbxHwImageUpgrader="$SBX_HW_IMAGE_BASED_UPGRADE_SH";

my $hwType = ` source $STAGING_SONUS_UTILS_SH ; getHwType `;
chomp($hwType);

# Use product string from sonusUtils.sh, getHwType returns 5100 even for 5110
my $prodString = `source $STAGING_SONUS_UTILS_SH ; $ECHO \$prodString`;
chomp($prodString);

my $lvcount=`$LVSCAN 2>/dev/null| $WC -l`;

sub printUsage()
{
  logMsg("Usage: $progname : -r <active|standby> -p <package-absolute-path> -n <deb-absolute-path> -o");
  exit 1;
}

##############################################################
# Main routine to validate input and drive LSWU steps
##############################################################
sub main()
{
  # note: option u is deprecated but needs to remain until older
  # versions of software that call this script with it are no
  # longer in the field
  getopts('r:p:u:n:oq');

  if ($opt_r)
  {
    $gRole = $opt_r;
    if ($gRole ne "active" && $gRole ne "standby" && $gRole ne "restartStandby")
    {
      printUsage();
    }
  }
  if ($opt_p)
  {
    $gPackage = $opt_p;
  }
  if ($opt_n)
  {
    $gDebName = $opt_n;
  }

  if ($opt_o)
  {
    # No action needed 
    # -o option is deprecated but keeping it for backward compatibility
    #  for upgrades from releases prior to 6.0
  }

  if ($opt_q)
  {
    # -q option is used to specify that upgrade is through P2. This option is
    # passsed only when sbx init process calls this script after logging in from P2. 
    # marker for PM
    `$ECHO "Upgrade in progress..." 2>/dev/null > $pmMarkerFile`;

    `$PERL $statusUpdater -r DiskPartition -s Status -v "Complete"`;
    $time=getTime();
    `$PERL $statusUpdater -r DiskPartition -s EndTime -v "$time"`;
    `$PERL $statusUpdater -r DiskPartition -s Reason -v "Successful_Completion"`;

    `$RM -f $ETC_INITD_SBX`;
    `$LN -fs $SBX_START_SH $ETC_INITD_SBX`;
  }
  else
  {
    # Perform disk speed check here in case of LSWU.
    if( !($hwType =~ m/ConnexIP5000/ ))
    {
       # When drbd sync is under progress the disk read performance will fall below desired threshold.
       # Hence we pause drbd sync when drbd connection status is not in 'Connected' state
       # assuming sync is under progress.
       my $syncFlag=0;
       if ( -e "/proc/drbd" )
       {
          if ( `$DRBDADM cstate mirror` ne "Connected" )
          {
             $syncFlag=1;
             `$DRBDADM pause-sync mirror > /dev/null 2>&1`;
             sleep(1);
          }
       }

       # Verify we have good enough disk read performance (per our desired threshold)
       my $result=system("$SH $STAGING_CHECK_DISK_PERFORMANCE_SH");
       if ( $result ne 0 )
       {
          # resume sync if paused
          if ($syncFlag == 1 )
          {
             `$DRBDADM resume-sync mirror > /dev/null 2>&1`;
          }
          logMsg("Disk read speed failed minimum requirement test. Exiting...");
          `$PERL $statusUpdater -s UpgradeStatus -v "upgradeFailed"`;
          `$PERL $statusUpdater -s Reason -v "diskPerformanceTestFailed_On_${gRole}.Possible_Recovery_Action_is:To_check_Disk_speed_or_To_Contact_Sonus_support."`;
          exit 1;
       }
       else
       {
          logMsg("Disk performance check passed...");
       }
       # resume sync if paused
       if ($syncFlag == 1 )
       {
          `$DRBDADM resume-sync mirror > /dev/null 2>&1`;
       }
    }

    # Upgrade just started, check if status file is created.
    if ( ! -e "$upgradeStatusFile" )
    {
      logMsg("$upgradeStatusFile doesnt exist!. Unable to get/set upgrade states.. Exiting... Contact Sonus support.");
      `$PERL $statusUpdater -s UpgradeStatus -v "upgradeFailed"`;
      `$PERL $statusUpdater -s Reason -v "Upgrade_StatusFile_is_not_created_On_${gRole}.Possible_Recovery_Action_is:To_contact_Sonus_support."`;
      exit 1;
    }
    else
    {
      $status=`$PERL $statusUpdater -g UpgradeStatus`;
      chomp($status);
      if ( "$status" =~ /none/ || "$status" =~ /ServerReverted/ )
      {
        # Lets wait for preInstallChecks to create status file
        logMsg("--------Starting STANDBY UPGRADE--------");
        sleep(5);
        `$PERL $statusUpdater -s UpgradeStatus -v "upgradingStandby"`;
      }
      elsif( "$status" =~ /postStandbyUpgradeChecks/ || "$status"  =~ /upgradingStandbyDone/ )
      {
         logMsg("--------Starting ACTIVE UPGRADE--------");
         `$PERL $statusUpdater -s UpgradeStatus -v "upgradingActive"`;
      }
      else
      {
          logMsg("Current upgradeStatus=$status...Possibly a manual CLI based upgrade.");
      }
    }

    # Remove dynamicHANewComps file if any left out from previous upgrade.
    # If present, will cause issues with sbxstatus output, thereby impacting upgrade. 
    if ( -e "$DYNAMIC_HA_NEW_COMPS" )
    {
      logMsg("Removing dynamicHANewComps file left out from previous upgrade.");
      `$RM -f $DYNAMIC_HA_NEW_COMPS`;
    }

    # store the original sbx version
    $origMajorVersion=getSWVersion("local");
    logMsg("origMajorVersion is $origMajorVersion");
    if( $origMajorVersion < 5 )
    {
      # Create pre50Marker.txt marker file
      logMsg("Creating pre50Marker.txt marker file..."); 
      `$ECHO "Upgrade from pre-5.0..." 2>/dev/null > $pre50MarkerFile`;

      # Install required qemu-utils packages for upgrades from 4.x
      logMsg("Installing required qemu-utils packages...");
      `$DPKG -i $sonusStaging/libiscsi*.deb`;
      `$DPKG -i $sonusStaging/qemu-utils*.deb`;
    }

    # Disable fstrim for Tuna.
    # By default fstrim is enabled
    # When fstrim.timer is enabled symlink is created.
    if( !($hwType =~ m/ConnexIP5000/ ))
    {
      logMsg("Disabling fstrim before upgrade...");
      my $linkFile = "/etc/systemd/system/timers.target.wants/fstrim.timer";
      if ( -e $linkFile && -l $linkFile )
      {
        logMsg("Fstrim is enabled. Disabling...");
        system("$SYSTEMCTL stop fstrim.timer");
        system("$SYSTEMCTL disable fstrim.timer");
        if (!(-e "$linkFile"))
        {
          logMsg("Fstrim is disabled.");
        }
      }
    }

    #Check if we are upgrading in DoD mode
    my $ret=system("$HOST_JITC_MODE_SH status 2>/dev/null |grep -q 'DoD mode enabled'");
    my $exitCode=$ret >> 8;
    if ( $exitCode == 0 )
    {
      logMsg("DoD mode Enabled. Setting DoD upgrade flag..");
      `$ECHO "Upgrading in DoD Mode.." > $DoDUpgradeMarker`;
      my $pmAccess=`$HOST_JITC_MODE_SH pmAccessStatus`;
      chomp($pmAccess);
      my $cliAccess=`$HOST_JITC_MODE_SH cliAccessStatus`;
      chomp($cliAccess);
      `$ECHO "PM=$pmAccess" >> $DoDUpgradeMarker`;
      `$ECHO "CLI=$cliAccess" >> $DoDUpgradeMarker`;
    }

    logMsg("Saving current configuration databases...");
    `$SAVE_CDB_SH`;

    # Save checksum file while upgrading from old oracle version to new
    # this is required to support revert in fips mode
    `$GREP "fipsMode=enabled" $SBXCONF_FILE`;
    if ( ! $? )
    {
        my $oracleDbCheckSumFile="/home/oracle/oracleDB.sha256sums";
        my $savedOracleDbCheckSumFile="/home/admin/oracle/oracleDB.sha256sums";
        if ( -e $oracleDbCheckSumFile && ! -e $savedOracleDbCheckSumFile )
        {
            logMsg("Copying oracleDB checksum file to $savedOracleDbCheckSumFile to support revert in fips mode");
            `$MKDIR -p /home/admin/oracle/`;
            `$CP $oracleDbCheckSumFile $savedOracleDbCheckSumFile`;
        }
    }

    if ( -e "/opt/sonus/staging/exportDB" )
    {
      # Add oracle/postgres users to sonus group, as they refer to files belonging to sonus group.
      `$_GROUPS oracle | $GREP -q sonus`;
      if ($? != 0)
      {
        logMsg("Adding oracle to sonus group");
        `$USERMOD -a -G sonus oracle`;
      }
      `$GETENT passwd postgres 2&> /dev/null`;
      if ( $? == 0 )
      {
        `$_GROUPS postgres | $GREP -q sonus`;
        if ($? != 0)
        {
          logMsg("Adding postgres to sonus group");
          `$USERMOD -a -G sonus postgres`;
        }
      }
      `$CHMOD 775 /opt/sonus/staging/exportDB`;
      chomp(my $SBC_VERSION=`/opt/sonus/sbx/scripts/swinfo.sh|$AWK -F: '/SBC:/{print \$2}' | $HEAD -1 | $TR -d ' '`);
      chomp(my $curTime=`$DATE +%y%m%d%H%M%S`);
      my $ssdbBackupFile="/home/admin/sonusdb_${SBC_VERSION}_${curTime}_for_upgrade.dmp";
      my $ssdbPgBackupFile="/home/admin/pg_sonusdb_${SBC_VERSION}_${curTime}_for_upgrade.dmp";
      system ("$RM -f /home/admin/pg_sonusdb_*_for_upgrade.dmp");
      my $ret=system("/opt/sonus/staging/exportDB -file $ssdbBackupFile")>>8;
      if (( $ret == 0 ) && ( -e "$ssdbPgBackupFile" ))
      {
        logMsg("Database backup files is $ssdbBackupFile");
      }		
      else
      {
        logMsg("Operation Failed! /opt/sonus/staging/exportDB -file $ssdbBackupFile");
        exit 1;
      }
    }
    else
    {
      logMsg("Cannot find /opt/sonus/staging/exportDB...");
      exit 1;
    }

    # Get component list from aspinfo for future use. This is required when
    # we are upgrading from a lower version e.g 2.0 to 4.0. At this time we will not be using
    # remoteCnx for getting info from peer CE. At this time sbx is not running and asp will not up.

    my $susName = `$ASPINFO -c sus | $GREP "CE_Node" | $AWK '{print \$1}'` ;
    chomp($susName);
    if ( $susName eq "CE_Node2_2N_Su" )
    {
       $susName = "CE_Node1";
    }
    elsif( $susName eq "CE_Node1_2N_Su" )
    {
       $susName = "CE_Node2";
    }
    my $compListCommand = qq($ASPINFO su ${susName}_2N_Su | $GREP "${susName}_2N_Su_Comp_" | $SED 's/component list://' | $AWK '{print \$1}');
    system("$compListCommand>/opt/sonus/.sbxCompList");
  }

  # This is for backward compatibility,
  # when this option is first added, the software running (previous version(s))
  # don't know about this option, so it won't pass and cause failure,
  # so set the deb name to same as package name with extension .deb
  if ($gDebName eq "unknown")
  {
    $gDebName = $gPackage;
    $gDebName =~ s/sbc-V/sbc_/;
    $gDebName =~ s/.x86_64.tar.gz$/_amd64.deb/;
  }

  if ($gRole eq "unknown" ||
      $gPackage eq "unknown" ||
      $gDebName eq "unknown" )
  {
    printUsage();
  }

  if ( "$hostSubType" ne "virtualCloud" && ! -e $gPackage )
  {
     logMsg("Requested package $gPackage doesnt exist, Checking in subDir..");
     my $gExternalSubDir = $gPackage;
     $gExternalSubDir =~ s/sbc-V/sbc_V/;
     $gExternalSubDir =~ s/.x86_64.*//;
     my $packageName=basename($gPackage);
     if ( ! -e "$gExternalSubDir/$packageName" )
     {
       logMsg("Requested package $gExternalSubDir/$packageName doesnt exist");
       exit 1;
     }
     else
     {
         $gPackage="$gExternalSubDir/$packageName";
     }
  }

  if ( "$hostSubType" ne "virtualCloud" && ! -e $gDebName)
  {
    logMsg("Requested DEB $gDebName doesn't exist");
    exit 1;
  }

  logMsg("Running $progname with role: $gRole, package: $gPackage");

  checkUser();
  runChild();


  # stop sbx service
  stopSbxService();
  
  #save all the permissions in a file.
  logMsg("Started sbxPermissionCheck.sh script");
  system("$sonusStaging/sbxPermissionCheck.sh beforeUpgrade");
  logMsg("Completed sbxPermissionCheck.sh script");

  # Remove ePSX if installed at the beginning of upgrade.
  if ( -e $VIRSH )
  {
    my $ret=system("$VIRSH list --all |grep -q ePSX ");
    my $exitCode=$ret >> 8;
    if ( $exitCode == 0 )
    {
       logMsg("ePSX is installed. Removing ePSX using ova commands..");
       my $vmDeletionLogs=`$OVFINSTALL_SH delete ePSX`;
       chomp($vmDeletionLogs);
       logMsg("ePSX deletion logs:\n$vmDeletionLogs\n");
     }
  }

  if ( ($hwType =~ m/ConnexIP5000/ ) || ( $prodString =~ m/5100/ ) )
  {
     `$ECHO "Upgrade in progress..." 2>/dev/null > $pmMarkerFile`;
     logMsg("Saving openclovis and tailf logs...");
     `$SAVE_OC_LOGS_SH`;
     `$SAVE_TAILF_LOGS_SH`;

     if ( -e "$sbxImageUpgrader" )
     {
        logMsg("Calling $sbxImageUpgrader...");
        system("chmod +x $sbxImageUpgrader");
        #-L logfile, '-l' flag to indicate LSWU
        system("$sbxImageUpgrader -L $sbxUpgradeLogFile -l");
        exit(0);
     }
     else
     {
        logMsg("ERROR: $sbxImageUpgrader doesnt exist. hostSubType=$hostSubType.");
        exit(1);
     }
  }
  else
  {
     if ( $lvcount == 1 )
     {
        logMsg("--------Starting DISK RE-PARTITION--------");
        `$PERL $statusUpdater -r DiskPartition -s Status -v "inProgress"`;
        $time=getTime();
        `$PERL $statusUpdater -r DiskPartition -s StartTime -v "$time"`;

        checkDiskforRevert("LSWU","$p2sbxUpgradeCommand","$lvcount" );
     }
     elsif ( $lvcount == 3 )
     {
        # Backup home directory
        logMsg("Taking /home backup...");
        if ( ! -d "$HOME_BACKUP_DIR" )
        {
          `$MKDIR -p $HOME_BACKUP_DIR`;
        }

        backupHomeDir();
        saveCommonDirPerms();

        `$ECHO "Db upgrade is required " > $dbUpgradeMarker`;

        if ( -e "$sbxHwImageUpgrader" )
        {
           logMsg("Calling $sbxHwImageUpgrader...");
           system("chmod +x $sbxHwImageUpgrader");
           system("$sbxHwImageUpgrader -L $sbxUpgradeLogFile -l");
           exit(0);
        }
        else
        {
           logMsg("ERROR: $sbxHwImageUpgrader doesnt exist. hostSubType=$hostSubType.");
           exit(1);
        }
     }
     else
     {
        logMsg("ERROR: Cannot proceed with upgrade. Number of LVMs=$lvcount.");
        exit(1);
     }
 
  }
}

if ( ! -e "$LIVE_UPGRADE_ACTIVE_KEY" )
{
  `$ECHO "Upgrade started.." > $LIVE_UPGRADE_ACTIVE_KEY`;
  $cmd="$TOUCH $LIVE_UPGRADE_ACTIVE_KEY";
  peerCommand ($cmd);
}

# Open a ssh handle to peer to write logs.
openPeerHandle();

logStartUpdate("LSWU-upgrade");

if ( -e "$STAGING_SBX_REVERT_PL" )
{
  if ( -d "$SONUS_INSTALLUPGRADE_DIR")
  {
    `$CP -fp $STAGING_SBX_REVERT_PL $SONUS_INSTALLUPGRADE_DIR/`;
    `$CHMOD 0775 $SBX_REVERT_PL`;
  }
  else
  {
    `$CP -fp $STAGING_SBX_REVERT_PL $SONUS_DIR/`;
    `$CHMOD 0775 $OLD_SBX_REVERT_PL`;
  }
  if ( -d "$SONUS_REVERT_DIR" )
  {
    `$RM -fr $SONUS_REVERT_DIR/*`;
  }
  else
  {
    `$MKDIR -p $SONUS_REVERT_DIR`;
    `$CHMOD 0775 $SONUS_REVERT_DIR`;
  }
  logMsg("Copying sonusCommands to revert dir(only to be used by sbxRevert.pl after revert)");
  `$CP $SONUS_STAGING_DIR/sonusCommands.pm $SONUS_STAGING_DIR/sonusCommonFiles.pm $SONUS_STAGING_DIR/sbxCommonFunctions.pm $SONUS_REVERT_DIR/`;
}
else
{
  logMsg("Unable to find Upgrade utility $STAGING_SBX_REVERT_PL. Possible Recovery Action is: Check package integrity. Exiting..");
  exit 1;
}

unless (-e "$STAGING_REVERT_UTIL_SH")
{
  logMsg("Unable to find Upgrade utility $STAGING_REVERT_UTIL_SH. Possible Recovery Action is: Check package integrity. Exiting..");
  exit 1;
}

unless (-e "$STAGING_SWITCH_BOOT_SH")
{
  logMsg("Unable to find Upgrade utility $STAGING_SWITCH_BOOT_SH. Possible Recovery Action is: Check package integrity. Exiting..");
  exit 1;
}

unless (-e "$STAGING_PARTITION_TOOL_SH")
{
  logMsg("Unable to find Upgrade utility $STAGING_PARTITION_TOOL_SH. Possible Recovery Action is: Check package integrity. Exiting..");
  exit 1;
}
`$CP -f $STAGING_PARTITION_TOOL_SH $STAGING_SWITCH_BOOT_SH $STAGING_REVERT_UTIL_SH /usr/local/bin`;
`$CHMOD 0775 $REVERT_UTIL_SH $SWITCH_BOOT_SH $PARTITION_TOOL_SH`;

main();

logEndUpdate();
