#!/bin/bash

# Script to include all full path common files as variables. 
# Please use these variables, rather than full paths.

declare APACHE_FAILURE_ALARM_TXT="/var/log/sonus/sbx/.apache_failure_alarm.txt"
declare AWS_CLOUDWATCH_DIR="/var/log/sonus/cloudwatch"
declare AWS_META_DATA_URL_PRODUCT_CODE="http://169.254.169.254/latest/meta-data/product-codes"
declare ETC_GRUBD_DIR="/etc/grub.d"
declare HOME_ADMIN="/home/admin"
declare HOME_ADMIN_SSH_DIR="/home/admin/.ssh"
declare HOME_BACKUP_DIR="/var/log/sonus/install/backup"
declare HOME_COMMON="/home/common"
declare HOME_CONFDADMIN="/home/confdadmin"
declare HOME_ETC_DEFAULT_DIR="/home/etc/default"
declare HOME_ETC_DEFAULT_PREV_DIR="/home/etc/default.prev"
declare HOME_ETC_GRUBD_DIR="/home/etc/grub.d"
declare HOME_ETC_GRUBD_PREV_DIR="/home/etc/grub.d.prev"
declare HOME_ORACLE="/home/oracle"
declare HOME_SFTPROOT="/home/sftproot"
declare HOME_SONUSADMIN="/home/sonusadmin"
declare ICM_TEST_SH="/opt/sonus/sbx/scripts/icmTest.sh"
declare LIB_FIRMWARE_DIR="/lib/firmware"
declare LIB_GLUSTERD_DIR="/var/lib/glusterd"
declare LIB_SYSTEMD_SYSTEM="/lib/systemd/system"
declare MARK_EMS_INSTANCE_UP_EVENT_IN_PROGRESS="/var/log/sonus/tmp/.emsInstanceUpProgress"
declare MARK_SBC_INSTANCE_UP_DONE="/var/log/sonus/tmp/.sbcInstanceUpDone"
declare MONIT_CONFD_DIR="/etc/monit/conf.d"
declare OAM_AGENT_DB_STATS_DIR="/var/log/intervalStats/oamDBStats"
declare OAM_AGENT_FILE_STATS_DIR="/var/log/intervalStats/fileStats"
declare OAM_AGENT_LOCAL_DBSTATS_DIR="/var/log/sonus/oamDBStats"
declare SFTPROOT_LOG_EMA_DIR="/home/sftproot/log/sonus/ema"
declare SFTPROOT_LOG_INSTALL_DIR="/home/sftproot/log/sonus/install"
declare SFTPROOT_LOG_SBXPERF_DIR="/home/sftproot/log/sonus/sbxPerf"
declare SFTPROOT_LOG_UPGRADE_DIR="/home/sftproot/log/sonus/upgrade"
declare SONUS_BACKUP_DIR="/opt/sonus/backup"
declare SONUS_BIN_DIR="/opt/sonus/bin"
declare SONUS_BIN_NP_DIR="/opt/sonus/bin/np"
declare SONUS_BIN_NP_SWE_DIR="/opt/sonus/bin/np/swe"
declare SONUS_BIN_SBX_PEER_EXPECT_PL="/opt/sonus/bin/sbxPeerExpect.pl"
declare SONUS_BIN_SWE_DIR="/opt/sonus/bin/swe"
declare SONUS_CNXIPM_BIN_DIR="/opt/sonus/cnxipm/bin"
declare SONUS_CNXIPM_CONF_DIR="/opt/sonus/cnxipm/conf"
declare SONUS_CNXIPM_DIR="/opt/sonus/cnxipm"
declare SONUS_CONFD_DIR="/opt/sonus/sbx/Confd"
declare SONUS_CONFD_SH_DIR="/opt/sonus/sbx/Confd/sh"
declare SONUS_CONFIG_STORE_DIR="/mnt/gfsvol1"
declare SONUS_CONF_DIR="/opt/sonus/conf"
declare SONUS_CONF_SWE_DIR="/opt/sonus/conf/swe/capacityEstimates"
declare SONUS_DEBUGUTILS_DIR="/opt/sonus/sbx/scripts/debugUtils"
declare SONUS_DIAGS_DIR="/opt/sonus/diags"
declare SONUS_DIR="/opt/sonus"
declare SONUS_EMA_APACHE_DIR="/opt/sonus/ema/apache"
declare SONUS_EMA_DIR="/opt/sonus/ema"
declare SONUS_EMA_SBXEMA_DIR="/opt/sonus/ema/sbxema"
declare SONUS_ENABLE_PUBLIC_CLOUD_ROOT="/opt/sonus/sbx/bin/EnablePublicCloudRoot"
declare SONUS_ETC_DIR="/opt/sonus/etc"
declare SONUS_ETC_INITD_DIR="/opt/sonus/etc/init.d"
declare SONUS_EXTERNAL_DIR="/opt/sonus/external"
declare SONUS_FAC_KEYELEMENT_RECORD_PATH="/var/log/sonus/fackeyelements"
declare SONUS_FAULTRECORD_FILE_FOLDER="/home/sftproot/evlog/faultrecord"
declare SONUS_FAULTRECORD_FILE_PATH="/home/sftproot/evlog/faultrecord/FaultRecord_"
declare SONUS_INSTALLUPGRADE_DIR="/opt/sonus/installUpgrade"
declare SONUS_INSTALLUPGRADE_LOG_DIR="/opt/sonus/installUpgrade/log"
declare SONUS_INTEL_UCODE_DIR="/opt/sonus/intel-ucode"
declare SONUS_INTERVAL_STATS_DEFLATE_DIR="/var/log/sonus/sbx/cloud_watch_stats"
declare SONUS_INTERVAL_STATS_DIR="/var/log/sonus/evlog/statistics"
declare SONUS_OPENCLOVIS_BIN_DIR="/opt/sonus/sbx/openclovis/bin"
declare SONUS_OPENCLOVIS_DIR="/opt/sonus/sbx/openclovis"
declare SONUS_OPENCLOVIS_ETC_DIR="/opt/sonus/sbx/openclovis/etc"
declare SONUS_OPENCLOVIS_LIB_DIR="/opt/sonus/sbx/openclovis/lib"
declare SONUS_OPENCLOVIS_VAR_DIR="/opt/sonus/sbx/openclovis/var"
declare SONUS_OPENCLOVIS_VAR_LIB_DIR="/opt/sonus/sbx/openclovis/var/lib"
declare SONUS_OPENCLOVIS_VAR_LOG_BACKTRACE_FILE="/opt/sonus/sbx/openclovis/var/log/backtrace.log"
declare SONUS_OPENCLOVIS_VAR_RUN_DIR="/opt/sonus/sbx/openclovis/var/run"
declare SONUS_PSX_DIR="/opt/sonus/sbx/psx"
declare SONUS_PSX_LIB_DIR="/opt/sonus/sbx/psx/lib"
declare SONUS_PSX_SQL_DIR="/opt/sonus/sbx/psx/sql"
declare SONUS_REVERT_DIR="/opt/sonus/revert"
declare SONUS_SBX_BIN_DIR="/opt/sonus/sbx/bin"
declare SONUS_SBX_CCL_DIR="/opt/sonus/sbx/ccl"
declare SONUS_SBX_CLI_DIR="/opt/sonus/sbx/cli"
declare SONUS_SBX_DIR="/opt/sonus/sbx"
declare SONUS_SBX_FXS_DIR="/opt/sonus/sbx/fxs"
declare SONUS_SBX_LCA_DIR="/opt/sonus/sbx/lca"
declare SONUS_SBX_LIB_DIR="/opt/sonus/sbx/lib"
declare SONUS_SBX_MIB_DIR="/opt/sonus/sbx/mib"
declare SONUS_SBX_SCRIPT_DIR="/opt/sonus/sbx/scripts"
declare SONUS_SBX_SH_DIR="/opt/sonus/sbx/sh"
declare SONUS_SBX_SWE_DIR="/opt/sonus/sbx/swe"
declare SONUS_SBX_UTILITIES_DIR="/opt/sonus/sbx/utilities"
declare SONUS_SBX_UTILITIES_NP_DIR="/opt/sonus/sbx/utilities/np"
declare SONUS_SBX_UTILITIES_NRS_DIR="/opt/sonus/sbx/utilities/nrs"
declare SONUS_SBX_UTILITIES_SP_DIR="/opt/sonus/sbx/utilities/sp"
declare SONUS_SECURELINK_DIR="/opt/sonus/securelink"
declare SONUS_STAGING_DIR="/opt/sonus/staging"
declare SONUS_STARTUP_ERRORS_LOG_DIR="/var/log/sonus/startuperrors"
declare SONUS_TAILF_BIN_DIR="/opt/sonus/sbx/tailf/bin"
declare SONUS_TAILF_CDB_DIR="/opt/sonus/sbx/tailf/var/confd/cdb"
declare SONUS_TAILF_CONFD_DIR="/opt/sonus/sbx/tailf/var/confd"
declare SONUS_TAILF_DIR="/opt/sonus/sbx/tailf"
declare SONUS_TAILF_LIB_DIR="/opt/sonus/sbx/tailf/lib"
declare SONUS_TAILF_VAR_DIR="/opt/sonus/sbx/tailf/var"
declare SONUS_LOG_CNXIPM_DIR="/var/log/sonus/cnxipm"
declare SONUS_LOG_CNXIPM_DIR_SFTPROOT="/home/sftproot/var/log/sonus/cnxipm"
declare SONUS_LOG_COMMON_COREDUMP_DIR="/var/log/sonus/coredump"
declare SONUS_LOG_COREDUMP_DIR="/var/log/sonus/sbx/coredump"
declare SONUS_LOG_COREDUMP_DIR_FOR_CONTAINER="/mnt/core"
declare SONUS_LOG_COREDUMP_KERNEL_DIR="/var/log/sonus/sbx/coredump/kernel"
declare SONUS_LOG_DIR="/var/log/sonus"
declare SONUS_LOG_EMA_DIR="/var/log/sonus/ema"
declare SONUS_LOG_EVLOG_CONFIG_DIR="/var/log/sonus/evlog/config"
declare SONUS_LOG_EVLOG_CONFIG_EMA_DIR="/var/log/sonus/evlog/config/ema"
declare SONUS_LOG_EVLOG_DIR="/var/log/sonus/evlog"
declare SONUS_LOG_EVLOG_ES_CLUSTER_DIR="/var/log/sonus/evlog/evlog/ES_CLUSTER"
declare SONUS_LOG_EXPORT_CURRENT_DIR="/var/log/sonus/export/current"
declare SONUS_LOG_EXPORT_DIR="/var/log/sonus/export"
declare SONUS_LOG_EXPORT_HISTORY_DIR="/var/log/sonus/export/history"
declare SONUS_LOG_EXPORT_LATEST_DIR="/var/log/sonus/export/latest"
declare SONUS_LOG_GLUSTERFS_DIR="/var/log/sonus/glusterfs"
declare SONUS_LOG_HIDS_DIR="/var/log/sonus/hids"
declare SONUS_LOG_INSTALL_DIR="/var/log/sonus/install"
declare SONUS_LOG_INTERVAL_STATS_DIR="/var/log/intervalStats"
declare SONUS_LOG_MIRROR_ANNOUNCEMENTS_DIR="/var/log/sonus/mirror/announcements"
declare SONUS_LOG_MIRROR_CONFIG_DIR="/var/log/sonus/mirror/config"
declare SONUS_LOG_MIRROR_DIR="/var/log/sonus/mirror"
declare SONUS_LOG_MIRROR_EVLOG_DIR="/var/log/sonus/mirror/evlog"
declare SONUS_LOG_NP_DIR="/var/log/sonus/np"
declare SONUS_LOG_OOM_DIR="/var/log/sonus/oom"
declare SONUS_LOG_OPENCLOVIS_DIR="/var/log/sonus/sbx/openclovis"
declare SONUS_LOG_OPENCLOVIS_SAVED_DIR="/var/log/sonus/sbx/asp_saved_logs/normal"
declare SONUS_LOG_PREV_REL_COREDUMPS_DIR="/var/log/sonus/sbx/coredump/.prevRelCoreDumps"
declare SONUS_LOG_SBXPERF="/var/log/sonus/sbxPerf"
declare SONUS_LOG_SBX_CONFIG_DIR="/var/log/sonus/sbx/config"
declare SONUS_LOG_SBX_DIR="/var/log/sonus/sbx"
declare SONUS_LOG_SBX_DEBUG_DEFAULT_LOG="sbx_debug_common.log"
declare SONUS_LOG_SBX_DEBUG_LOG="/var/log/sbx_debug_log"
declare SONUS_LOG_SBX_EVLOG_DIR="/var/log/sonus/sbx/evlog"
declare SONUS_LOG_SBX_EVLOG_VALIDATION_DIR="/var/log/sonus/sbx/evlog/eventLogValidation"
declare SONUS_LOG_SBX_TAILF_DIR="/var/log/sonus/sbx/tailf"
declare SONUS_LOG_SSDB_DIR="/var/log/sonus/ssdb"
declare SONUS_LOG_TMP_CNXIPM_DIR="/var/log/sonus/tmp/cnxipm"
declare SONUS_LOG_TMP_ICM_DIR="/var/log/sonus/tmp/icm"
declare SONUS_LOG_TSHARK_DIR="/var/log/tsharkLog"
declare SONUS_LOG_UPGRADE_CURRENT_DIR="/var/log/sonus/upgrade/current"
declare SONUS_LOG_UPGRADE_DIR="/var/log/sonus/upgrade"
declare SONUS_LOG_UPGRADE_LATEST_DIR="/var/log/sonus/upgrade/latest"
declare SONUS_LOG_UPGRADE_PRECHECKS_DIR="/var/log/sonus/upgrade/preChecks"
declare SONUS_TMP_DIR="/var/log/sonus/tmp"
declare SONUS_VAR_SPOOL_CRON_CRONTABS="/var/spool/cron/crontabs"

declare AAA_INIT_FILE="/opt/sonus/sbx/tailf/var/confd/cdb/aaa_init.xml"
declare ABORT_SENT_TO_PID="/var/log/sonus/tmp/abortSentToPid"
declare ACCOUNT_AGING_SH="/opt/sonus/sbx/scripts/accountAging.sh"
declare ACT_CALLMIX_JSON="/opt/sonus/conf/swe/capacityEstimates/.activeCallMixInput.json"
declare ACT_CORE_PARTITION="/opt/sonus/conf/swe/capacityEstimates/.actCorePartition"
declare ACTUAL_NAME_CONF="/opt/sonus/conf/actualName.conf"
declare ADDARG_PL="/opt/sonus/sbx/scripts/addarg.pl"
declare ADD_DISK_IN_SW_RAID_SH="/opt/sonus/sbx/scripts/addDiskInSwRaid.sh"
declare ADDENV_PL="/opt/sonus/sbx/scripts/addenv.pl"
declare ADD_TO_ETC_HOSTS_SH="/opt/sonus/sbx/sh/addToEtcHosts.sh"
declare ADMINRESET_USERCLIPWD_SH="/opt/sonus/sbx/sh/adminreset_userclipwd.sh"
declare AIDE_CONF="/etc/aide/aide.conf"
declare AIDE_SH="/opt/sonus/sbx/scripts/aide.sh"
declare ANONYMIZATION_DATA_FILE="/var/log/sonus/cloudwatch/cw_agent_act_anonymised_data.log"
declare ANONYMIZATION_LOG_FILE="/var/log/sonus/anonymise/anonymization.log"
declare ANONYMIZE_LOGS_PY="/opt/sonus/sbx/scripts/anonymizeLogs.py"
declare APACHE_CONFIG_PATH="/etc/apache2/sites-available"
declare APPARMOR_GRUB="/etc/default/grub.d/apparmor.cfg"
declare APP_NETUTILS="/opt/sonus/bin/go_app"
declare ASP_CONSOLE="/opt/sonus/sbx/openclovis/bin/asp_console"
declare ASPINFO="/opt/sonus/sbx/openclovis/bin/aspinfo"
declare AUTH_HIDE_GROUP_USER_SH="/opt/sonus/sbx/sh/authHideGroupUser.sh"
declare AUTHORIZE_PEER_SSH_SH="/opt/sonus/sbx/scripts/authorizePeerSsh.sh"
declare AWS_CLOUDWATCH_CONFIG_ANONYMIZATION_FILE="/opt/aws/amazon-cloudwatch-agent/cloudwatch_anony_config.json"
declare AWS_CLOUDWATCH_CONFIG_METRIC_ANONYMIZATION_FILE="/opt/aws/amazon-cloudwatch-agent/cloudwatch_metric_anony_config.json"
declare AWS_CLOUDWATCH_CONFIG_METRIC_FILE="/opt/aws/amazon-cloudwatch-agent/cloudwatch_metric_config.json"
declare BACKUP_PAM_TALLYS="/opt/sonus/sbx/scripts/backupPamTallys.sh"
declare BANNER_CFG="/opt/sonus/conf/banner.cfg"
declare BANNER_TXT="/opt/sonus/conf/banner.txt"
declare BASHRC="/root/.bashrc"
declare BLINK_CONF="/opt/sonus/cnxipm/conf/blink.conf"
declare BUILDINFO="/opt/sonus/installUpgrade/.buildinfo"
declare BUILD_SONUS_HA_PORT_XML_SH="/opt/sonus/sbx/scripts/buildSonusHaPortXml.sh"
declare BUILD_SONUS_MGMT_IP_IFACE_DOT_XML_SH="/opt/sonus/sbx/scripts/buildSonusMgmtIpIfaceDotXml.sh"
declare BUILD_SONUS_NIF_DOT_XML_SH="/opt/sonus/sbx/scripts/buildSonusNifDotXml.sh"
declare BUILD_SONUS_PORT_XML_SH="/opt/sonus/sbx/scripts/buildSonusPortXml.sh"
declare BUILD_SONUS_SYSTEM_DOT_XML_SH="/opt/sonus/sbx/scripts/buildSonusSystemDotXml.sh"
declare CALLMIX_INPUT_JSON="/opt/sonus/conf/swe/capacityEstimates/.callMixInput.json"
declare CALLS_ESTIMATE_TXT="/opt/sonus/conf/swe/capacityEstimates/.callsEstimate.txt"
declare CAVCREEK_INSTALLER_SH="/opt/sonus/sbx/utilities/cavcreek/installer.sh"
declare CDB_RESULT_MARKER_TXT="/var/log/sonus/tmp/cdb_result_marker.txt"
declare CDB_WAIT_MARKER_TXT="/var/log/sonus/tmp/cdb_wait_marker.txt"
declare POSTGRESS_PEER_IP_SYNC_MARKER="/var/log/sonus/tmp/postgressPeerIpSyncMarker"
declare CHANGE_CLIPWD_SH="/opt/sonus/sbx/sh/change_clipwd.sh"
declare CHANGE_DEFAULT_CNXIPMADMIN_PASSWD_SH="/opt/sonus/sbx/sh/changeDefaultCnxipmadminPasswd.sh"
declare CHANGE_DEFAULT_PASSWDS_SH="/opt/sonus/sbx/sh/changeDefaultPasswds.sh"
declare CHANGE_LINUX_PASSWORD_EXP="/opt/sonus/sbx/sh/changeLinuxPassword.exp"
declare CHECK_DISK_USAGE_SH="/opt/sonus/sbx/scripts/checkDiskUsage.sh"
declare CHECK_DYNAMIC_HA_PL="/opt/sonus/sbx/scripts/checkDynamicHA.pl"
declare CHECK_IPV6_DAD_STATUS_SH="/opt/sonus/sbx/scripts/checkIpv6DadStatus.sh"
declare CHECK_ROLE_ASSIGNMENT_SH="/opt/sonus/sbx/scripts/checkRoleAssignment.sh"
declare CHECK_SYNC_STATUS_PL="/opt/sonus/sbx/scripts/checkSyncStatus.pl"
declare CHKROOTKIT_SH="/opt/sonus/sbx/scripts/chkrootkit.sh"
declare CLEANUP_ASP_CDB_SAVED_LOGS_SH="/opt/sonus/sbx/scripts/cleanupAspCdbSavedLogs.sh"
declare CLEANUP_NP_SH="/opt/sonus/bin/np/cleanupNP.sh"
declare CLEAR_DBS_SH="/opt/sonus/sbx/scripts/clearDBs.sh"
declare CLOUD_ADMIN_PUBLIC_KEY="/opt/sonus/certs/admin.pub"
declare CLOUD_DIAGS_PY="/home/linuxadmin/cloud_diags/cloud_diags.py"
declare CLOUD_DYNAMIC_DATA_JSON="/opt/sonus/conf/dynamicData.json"
declare CLOUD_GPU_CALLMIX_XML="/opt/sonus/conf/callmix.xml"
declare CLOUD_HFE_INTERFACE_DATA_JSON="/opt/sonus/conf/describeHfeInterface.json"
declare CLOUD_HFE_INTERFACE_DATA_XML="/opt/sonus/conf/describeHfeInterface.xml"
declare CLOUD_HYPERVISOR_TYPE_FILENAME="/opt/sonus/conf/hypervisorType.txt"
declare CLOUD_INSTANCE_DATA_JSON="/opt/sonus/conf/describeInstance.json"
declare CLOUD_INSTANCE_DATA_XML="/opt/sonus/conf/describeInstance.xml"
declare CLOUD_INTERFACE_DATA_XML="/opt/sonus/conf/describeInterface.xml"
declare CLOUD_INSTANCE_LCA_DATA_JSON="/opt/sonus/conf/instanceLcaData.json"
declare CLOUD_INSTANCE_META_VAR_JSON="/opt/sonus/conf/instanceMetaVar.json"
declare CLOUD_LINUXADMIN_PUBLIC_KEY="/opt/sonus/certs/linuxadmin.pub"
declare CLOUD_META_DATA_EMS_PSX_JSON="/opt/sonus/conf/metadata.json"
declare CLOUD_META_DATA_JSON="/opt/sonus/conf/metaData.json"
declare CLOUD_META_DATA_PERIODIC_UPDATE_JSON="/opt/sonus/conf/metaDataPeriodicUpdate.json"
declare CLOUD_META_DATA_VNFM_ORIG_JSON="/opt/sonus/conf/metaData_vnfm_orig.json"
declare CLOUD_NP_TRANSLATION_CONF="/opt/sonus/conf/haConvertIP.conf"
declare CLOUD_PEER_DATA_JSON="/opt/sonus/conf/peerData.json"
declare CLOUD_SELF_DATA_JSON="/opt/sonus/conf/selfData.json"
declare CLOUD_USER_DATA_TEXT="/opt/sonus/conf/userData.txt"
declare CLOUD_USER_DATA_JSON="/opt/sonus/conf/userData.json"
declare CLOUD_USER_DATA_VNFM_ORIG_JSON="/opt/sonus/conf/userData_vnfm_orig.json"
declare CLUSTER_MANAGER_PY="/opt/sonus/sbx/serf/clusterManager.py"
declare CNF_HEALTH_FILE_OPERATION="/opt/sonus/sbx/scripts/cnfHealthFileOperation.sh"
declare CNF_LOG_FILES_DIR="/home/sftproot/evlog/evlog"
declare CNF_STORAGE_METRIC_PY="/opt/sonus/bin/cnfStorageMetric.py"
declare CNF_SYSLOG_HEALTH_CHECK_SH="/opt/sonus/bin/cnfSyslogHealthCheck.sh"
declare CNI_IP_DETAILS_CONF="/opt/sonus/conf/swe/.cni_ip_details.conf"
declare CNXIPMADMIN_MARKER_FILE="/var/log/sonus/tmp/.cnxipmadminMarker"
declare CNXIPM_LOGROTATE_CONF="/opt/sonus/cnxipm/conf/logrotate.conf"
declare COLLECT_SWE_NP_LOGS_EXPECT="/opt/sonus/sbx/scripts/collect_swe_np_logs.expect"
declare COMMON_CRITERIA_MODE_SH="/opt/sonus/sbx/scripts/commonCriteriaMode.sh"
declare CONFD="/opt/sonus/sbx/tailf/bin/confd"
declare CONFD_CLI="/opt/sonus/sbx/tailf/bin/confd_cli"
declare CONFD_CMD="/opt/sonus/sbx/tailf/bin/confd_cmd"
declare CONFD_CONF="/opt/sonus/sbx/tailf/confd.conf"
declare CONFD_CONF_RMA="/home/cnxipmadmin/confd.conf.rma"
declare CONFD_LOAD="/opt/sonus/sbx/tailf/bin/confd_load"
declare CONFD_LOAD_XML_SH="/opt/sonus/sbx/sh/confdLoadXml.sh"
declare CONFIG_CUR_VER_FILE="/opt/sonus/conf/current-local-revision.txt"
declare CONFIG_DRIVE_STORE_DIR="/opt/sonus/conf/configDriveDir"
declare CONFIG_STORE_VER_FILE="/mnt/gfsvol1/config-versions.txt"
declare CONFIGUREDNS_SH="/opt/sonus/sbx/scripts/configuredns.sh"
declare CONFIGURE_AIDE_PY="/opt/sonus/sbx/scripts/configureAIDE.py"
declare CONFIGURE_BONDING_SH="/opt/sonus/sbx/scripts/configureBonding.sh"
declare CONFIGURE_DRBD_LOG_FILE="/var/log/sonus/configureDrbd.log"
declare CONFIGURE_FILEBEAT_SH="/opt/sonus/sbx/scripts/configureFilebeat.sh"
declare CONFIGURE_GRUB_PWD_SH="/usr/local/bin/configureGrubPwd.sh"
declare CONFIGURE_GRUB_SH="/usr/local/bin/configureGrub.sh"
declare CONFIGURE_LISTENER_SH="/opt/sonus/sbx/scripts/configureListener.sh"
declare CONFIGURE_OPENHPI_SH="/opt/sonus/sbx/scripts/configureOpenhpi.sh"
declare CONFIGURE_PKT_TUN_INTF_SH="/opt/sonus/bin/configurePktTunnelIntf.sh"
declare CONFIGURE_SECOND_MGMT_PORT_SH="/opt/sonus/sbx/scripts/configureSecondMgmtPort.sh"
declare CONFIGURE_SECONDARY_DISK_SH="/opt/sonus/bin/configureSecondaryDisk.sh"
declare CONNEXIP_OS_BUILDINFO="/etc/connexip_os_buildinfo"
declare CONNEXIP_OS_VERSION="/etc/connexip_os_version"
declare CONNEXIP_RESET_LOG="/connexipReset.log"
declare CONNEXIP_HMAC_SHA256SUMS="/var/lib/dpkg/info/connexip.hmacSha256sums"
declare COPY_FILE_WITH_PERMISSION="/opt/sonus/sbx/scripts/copyFileWithPermission.sh"
declare CONVERT_LICENSE_FILE_TO_CONFD_FORMAT_SH="/opt/sonus/sbx/scripts/convertLicenseFileToConfdFormat.sh"
declare COREDUMPS_AT_LAST_START="/var/log/sonus/sbx/coredump/coredumpsAtLastStart"
declare COREDUMPS_AT_THIS_START_MOST_RECENT="/var/log/sonus/sbx/coredump/coredumpsAtThisStartMostRecent"
declare COREDUMPS_AT_THIS_START="/var/log/sonus/sbx/coredump/coredumpsAtThisStart"
declare COREDUMP_SWE_DSP="/opt/sonus/bin/swe/coredumpSweDsp.sh"
declare CORE_PARTITION_ERR_TXT="/opt/sonus/conf/swe/capacityEstimates/.corePartitionError.txt"
declare CORE_PARTITION_PY="/opt/sonus/bin/np/swe/corePartition.py"
declare CORE_PARTITION_LOG="/var/log/sonus/np/corepartition.log"
declare CORE_PROCESSES="/opt/sonus/sbx/scripts/coreProcesses.py"
declare CPSAPPS_FILE="/var/log/sonus/.cps_registered_apps"
declare CPSD="/opt/sonus/etc/init.d/cpsd"
declare CPS_INTERFACES="/opt/sonus/etc/cps-interfaces"
declare CPS_SERVICE_FILE="/lib/systemd/system/cps.service"
declare CPSI="/opt/sonus/bin/cpsi"
declare CPU_CORE_SWE_TXT="/opt/sonus/conf/swe/capacityEstimates/.cpuCoreSwe.txt"
declare CREATE_EMA_TABLES_SH="/opt/sonus/ema/createEmaTables.sh"
declare CREATE_SERF_CONFIG_FILE_PY="/opt/sonus/sbx/serf/createSerfConfigFile.py"
declare CREATE_SSH_DAEMON_SH="/opt/sonus/sbx/scripts/createSshDaemon.sh"
declare CREATE_TRANSACTION_LOG_BUNDLE_SH="/opt/sonus/sbx/scripts/createTransactionLogBundle.sh"
declare CRON_LOG="/var/log/cron.log"
declare CSET_SH="/opt/sonus/bin/cset.sh"
declare CSTATE_PY="/opt/sonus/bin/cstate.py"
declare CTRL_ALT_DELETE_SH="/opt/sonus/sbx/scripts/ctrlAltDel.sh"
declare CURRENT_PLAYBACKNO_FILE="/opt/sonus/conf/current-playbackno.txt"
declare DBSTATS_UPDATE_PY="/opt/sonus/sbx/scripts/statsDbUpdate.py"
declare DB_UPGRADE_MARKER="/var/log/sonus/upgrade/.dbUpgradeMarker"
declare DDH_DSP100_UTILS_SH="/opt/sonus/sbx/scripts/ddhDsp100Utils.sh"
declare DHCLIENT_CONF="/etc/dhcp/dhclient.conf"
declare DIAGNOSE_CRON="/etc/cron.hourly/diagnoseCron"
declare DISABLEHEALTHCHECK_PL="/opt/sonus/sbx/scripts/disablehealthcheck.pl"
declare DISABLE_SAFPLUS_RESTART_SH="/opt/sonus/sbx/scripts/disableSafplusRestart.sh"
declare DISCARD_CANDIDATE_CONFIGURATION_FLAG="/mnt/gfsvol1/discardCandidateConfigFlag"
declare DISCARD_CANDIDATE_CONFIGURATION_SH="/opt/sonus/sbx/scripts/discardCandidateConfig.sh"
declare DISK_EVT_MARKER="/var/log/sonus/.diskErrorEvent"
declare DMESG_ANALYZER_SH="/opt/sonus/sbx/scripts/dmesgAnalyzer.sh"
declare DMESG_ERROR_MARKER="/var/log/sonus/tmp/dmesgErrorMarker.tmp"
declare DMESG_LOG_FILENAME="/var/log/dmesg"
declare DMESG_DISK_MARKER="/var/log/sonus/tmp/dmesgDiskTrapMarker.tmp"
declare DMESG_HW_MARKER="/var/log/sonus/tmp/dmesgHwTrapMarker.tmp"
declare DMIDECODE_OUT="/opt/sonus/conf/dmidecode.out"
declare DOCKER_START_SH="/opt/sonus/bin/dockerStart.sh"
declare DOCKER_START_LOG="/var/log/sonus/install/startupDocker.log"
declare DOCKER_STOP_MARKER="/var/log/sonus/tmp/.dockerStopMarker"
declare DPDK_GET_PKTQ="/opt/sonus/bin/np/swe/dpdk_get_pktq"
declare DRBD_CMD_SH="/opt/sonus/sbx/scripts/drbdCmd.sh"
declare DRBD_SBX_SERVICE_FILE="/etc/systemd/system/drbd.service"
declare DRBD_UTILS_SERVICE_FILE="/lib/systemd/system/drbd.service"
declare DRM_DSP_COREDUMP_MARKER_FILE="/opt/sonus/conf/sweDrmDspCoredumpMarker.txt"
declare DRM_DSP_DEVICE_MAP_FILE_SWE="/opt/sonus/conf/dspDeviceMap.txt"
declare DRM_GPU_ERROR_INFO_FILE="/opt/sonus/conf/drmGpuError.txt"
declare DRM_GPU_INFO_FILE="/opt/sonus/conf/drmGpu.txt"
declare DSP_INIT_MARKER_FILE="/opt/sonus/conf/swe/.dspinit_done"
declare DVR_INFO_FILE="/opt/sonus/sbx/.dvrInfo"
declare DYNAMIC_HA_CONTROL="/opt/sonus/sbx/bin/DynamicHaControl"
declare DYNAMIC_HA_NEW_COMPS="/opt/sonus/installUpgrade/log/dynamicHANewComps"
declare DYNAMIC_IPADDR_XML_FILENAME="/opt/sonus/sbx/lca/sonusDynamicIpAddress.xml"
declare EDCRYPT="/opt/sonus/sbx/psx/sql/edcrypt"
declare EMA_NAME_CHANGE_PL="/opt/sonus/ema/emaNameChange.pl"
declare EMS_CUR_CONFIG_VER_FILE="/opt/sonus/conf/current-ems-revision.txt"
declare EMS_INTERFACE_PY="/opt/sonus/lca/modules/emsInterface.py"
declare EMS_REGISTRATION_STATUS="/opt/sonus/conf/emsRegistrationStatus"
declare EMS_SWE_PROFILE_DONE_MARKER="/opt/sonus/conf/swe/capacityEstimates/.emsSweProfileActivtionDone"
declare ENABLE_FIPS_SH="/opt/sonus/sbx/scripts/enableFIPS.sh"
declare ENCRYPTED_STORE_CORE_SH="/opt/sonus/sbx/sh/encryptedStoreCore.sh"
declare ENCRYPTED_STORE_SH="/opt/sonus/sbx/sh/encryptedStore.sh"
declare ETC_APPLICATION="/etc/application"
declare ETC_DEFAULT_GRUB="/etc/default/grub"
declare ETC_DEFAULT_GRUBD="/etc/default/grub.d"
declare ETC_DRBD_CONF="/etc/drbd.conf"
declare ETC_FSTAB="/etc/fstab"
declare ETC_GROUP="/etc/group"
declare ETC_INITD_ASP="/opt/sonus/sbx/openclovis/etc/init.d/asp"
declare ETC_INITD_BFD="/opt/sonus/etc/init.d/bfd"
declare ETC_INITD_CHECKBONDING="/opt/sonus/etc/init.d/checkbonding"
declare ETC_INITD_CONNEXIP_OS="/opt/sonus/etc/init.d/connexip-os"
declare ETC_INITD_CHS="/opt/sonus/etc/init.d/chs"
declare ETC_INITD_CPS="/opt/sonus/etc/init.d/cps"
declare ETC_INITD_DRBD="/etc/init.d/drbd"
declare ETC_INITD_INSTALLCNXIPM="/opt/sonus/etc/init.d/installcnxipm"
declare ETC_INITD_LCA="/opt/sonus/etc/init.d/lca"
declare ETC_INITD_SBX="/opt/sonus/etc/init.d/sbx"
declare ETC_INITD_SBXBOND="/opt/sonus/etc/init.d/sbxbond"
declare ETC_INITD_SBXCGROUPS="/opt/sonus/etc/init.d/sbxcgroups"
declare ETC_INITD_SBXIRQBALANCE="/opt/sonus/etc/init.d/sbxirqbalance"
declare ETC_INITD_SBXPERF="/opt/sonus/etc/init.d/sbxPerf"
declare ETC_INITD_SERF="/opt/sonus/etc/init.d/serf"
declare ETC_INITD_SERFMEMBERSHIP="/opt/sonus/etc/init.d/serfMembership"
declare ETC_INITD_SFIPS_POST="/opt/sonus/etc/init.d/sfips-post"
declare ETC_INITD_SONUSINITDSYSTEMDSYNC="/opt/sonus/etc/init.d/sonusInitdSystemDSync"
declare ETC_INITD_SONUSUDEV="/opt/sonus/etc/init.d/sonusudev"
declare ETC_INPUTRC="/etc/inputrc"
declare ETC_LOGROTATE_AIDE="/etc/logrotate.d/aideLogrotate"
declare ETC_LOGROTATE_PM="/etc/logrotate.d/platformManager"
declare ETC_LOGROTATE_RSYSLOG="/etc/logrotate.d/rsyslog"
declare ETC_LOGROTATE_SBXPERFORMANCE="/etc/logrotate.d/sbxPerformance"
declare ETC_NETWORK_FILE="/etc/network/interfaces"
declare ETC_OPENSSL_CSR_CNF="/opt/sonus/sbx/etc/openssl-csr.cnf"
declare ETC_PASSWD="/etc/passwd"
declare ETC_PKT_PORT_SPEED="/etc/pktPortSpeed"
declare ETC_SSH_CONFIG="/etc/ssh/ssh_config"
declare ETC_SSHD_CONFIG="/etc/ssh/sshd_config"
declare ETC_SSHD_CONFIG_22="/etc/ssh/sshd_config_22"
declare ETC_SSHD_CONFIG_2022="/etc/ssh/sshd_config_2022"
declare ETC_SSHD_RIBBON_CONFIG="/etc/ssh/sshd_ribbon_config"
declare ETC_SYSCTL_CONF="/etc/sysctl.conf"
declare ETHTOOL_SH="/opt/sonus/sbx/scripts/ethtool.sh"
declare EXPORT_PLAYBACKFILES_SH="/opt/sonus/sbx/scripts/exportPlaybackFiles.sh"
declare EXTERNAL_AUTHENTICATION="/opt/sonus/sbx/bin/ExternalAuthentication"
declare FDISK_SH="/opt/sonus/sbx/scripts/fdisk.sh"
declare FE_DEPLOYMENT_MARKER_FILE="/opt/sonus/conf/feDeploymentMarker"
declare FE_SBXCONF_FILE="/opt/sonus/conf/fe_sbx.conf"
declare FETCH_PEER_IP="/opt/sonus/bin/fetchPeerIp.py"
declare FIND_LOGS_TO_HASH_SH="/opt/sonus/sbx/sh/findLogsToHash.sh"
declare FIND_SERVICE_UP_TIME_SH="/opt/sonus/sbx/scripts/findServiceUpTime.sh"
declare FIPS_MODULE_CNF="/usr/local/ssl/fipsmodule.cnf"
declare FIPS_OPEN_SSL_SH="/opt/sonus/sbx/scripts/fipsOpenssl.sh"
declare FIPS_SO="/usr/lib/x86_64-linux-gnu/ossl-modules/fips.so"
declare RBBNENTROPY_SO="/usr/lib/x86_64-linux-gnu/ossl-modules/rbbnEntropy.so"
declare FIRSTBOOT_FE_PY="/usr/local/bin/firstboot_fe.py"
declare FIRSTBOOT_FILENAME="/var/log/firstboot.log"
declare FIRSTBOOT_SH="/usr/local/bin/firstboot.sh"
declare FIRST_ESTIMATE_MARKER="/opt/sonus/conf/swe/capacityEstimates/.firstEstimateDoneMarker.txt"
declare FM_DSP_MC_LEVEL_MAP_FILE_SWE="/opt/sonus/conf/dspMCLevelMap.txt"
declare FPGAUTIL_PL="/opt/sonus/sbx/scripts/fpgaUtil.pl"
declare GDB_STACK_TRACE_SH="/opt/sonus/sbx/scripts/gdbStackTrace.sh"
declare GENERATE_EMA_CERT_SH="/opt/sonus/sbx/scripts/generateEmaCert.sh"
declare GENERATE_VNFR_CERT_SH="/opt/sonus/sbx/scripts/generateVnfrCerts.sh"
declare GENERATE_ENC_KEYS_SH="/opt/sonus/sbx/scripts/generateEncKeys.sh"
declare GENERATE_NS_SEED_XML_PY="/opt/sonus/bin/generateNetworkSegmentSeedXml.py"
declare GENERATE_PWD_SH="/opt/sonus/sbx/sh/generatePwd.sh"
declare GENERATE_SSH_KEYS_SH="/opt/sonus/sbx/scripts/generateSshKeys.sh"
declare GENWORKQ_KO="/opt/sonus/lib/modules/genworkq.ko"
declare GEO_REDUND_HA_SH="/opt/sonus/sbx/scripts/geoRedundHa.sh"
declare GET_AND_UPDATE_PSWD_PY="/opt/sonus/lca/modules/getAndUpdatePasswords.py"
declare GET_DHCP_SCRIPT="/opt/sonus/sbx/scripts/getDhcpSettings.sh"
declare GET_DHCP_META_VAR_XML_FILENAME="/opt/sonus/sbx/lca/sonusMetaVariablesGetDhcp.xml"
declare GET_EMS_PARAMETERS_PY="/opt/sonus/sbx/scripts/getEmsParameters.py"
declare GET_SYSTEM_INFO_SH="/opt/sonus/bin/getSystemInfo.sh"
declare GLUSTER_SETUP_SH="/opt/sonus/sbx/scripts/glusterSetup.sh"
declare GPU_UXPAD_CONFIG="/opt/sonus/bin/np/swe/uxpadConfig.py"
declare GROUPADD_SH="/opt/sonus/sbx/sh/groupadd.sh"
declare GROUPDEL_SH="/opt/sonus/sbx/sh/groupdel.sh"
declare GROW_DRBD_PARTITION_PENDING="/opt/sonus/conf/growDrbdPartitionPending"
declare GROW_ROOT_PARTITION_PY="/opt/sonus/bin/growRootPartition.py"
declare GRUB_CONFIG="/boot/grub/grub.cfg"
declare GRUB_MENU_LST="/boot/grub/menu.lst"
declare HA_PAIR_MARKER="/var/log/sonus/tmp/.haPairMarker"
declare HIGH_CALL_CAP_MARKER_FILE="/opt/sonus/conf/swe/capacityEstimates/.highCallCapMarker.txt"
declare HOSTCHECK_MARKER_FILE="/var/log/sonus/tmp/hostCheckFail"
declare HOST_CHECK="/opt/sonus/sbx/scripts/HostCheck"
declare HOST_JITC_MODE_APACHE_SH="/opt/sonus/sbx/scripts/hostJITCModeApache.sh"
declare HOST_JITC_MODE_SH="/opt/sonus/sbx/scripts/hostJITCMode.sh"
declare HOST_JITC_STIG_RULES_SH="/opt/sonus/sbx/scripts/hostJITCStigRules.sh"
declare HOST_SUB_TYPE="/etc/hostSubType"
declare HOST_TYPE="/etc/hostType"
declare HPA_METRICS_JSON_FILE="/opt/sonus/metrics/appData.json"
declare HW_EVT_MARKER="/var/log/sonus/.hardwareErrorEvent"
declare HWINFO_SH="/opt/sonus/sbx/scripts/hwinfo.sh"
declare HWINFO="/usr/local/bin/hwinfo"
declare IGNORE_DB_PROFILE_MARKER="/opt/sonus/conf/swe/capacityEstimates/.ignoreActiveProfileInDB"
declare IMPORT_PLAYBACK_FILE_SH="/opt/sonus/sbx/scripts/importPlaybackFile.sh"
declare INDEX_MARKER="/opt/sonus/conf/swe/capacityEstimates/.indexMarker"
declare INDEX_TXT="/opt/sonus/conf/swe/capacityEstimates/.index.txt"
declare INDEX_TXT_ORIG_FILE="/opt/sonus/conf/swe/capacityEstimates/.index.txt.orig"
declare INDEX_TXT_TMP="/opt/sonus/conf/swe/capacityEstimates/tmp/.index.txt"
declare INSTALL_LOG="/var/log/sonus/install/install-log"
declare INSTALL_UPGRADE_MARKER="/home/common/.installUpgradeMarker"
declare IP6TABLES_SH="/opt/sonus/sbx/scripts/ip6tables.sh"
declare IPMITOOL_SH="/opt/sonus/sbx/scripts/ipmitool.sh"
declare IPSEC_STAT="/opt/sonus/bin/np/swe/ipsec-stat"
declare IPTABLES_SH="/opt/sonus/sbx/scripts/iptables.sh"
declare ISVIRTUAL_TXT="/opt/sonus/conf/isVirtual.txt"
declare KEY_KEEPER_PY="/opt/sonus/lca/modules/keyKeeper.py"
declare LAST_EMS_UPLOADED_REVISION="/mnt/gfsvol1/lastEmsUploadedRevision.txt"
declare LAST_EXCHANGED_METAVAR_NODE_NAME="/opt/sonus/sbx/lca/lastExchangedMetavarNodeName"
declare LCA_ERR_MARKER="/var/log/sonus/tmp/.lcaErrorLog"
declare LCA_LOG_FILENAME="/var/log/sonus/lca/lca.log"
declare LCA_MARKER_FILE="/tmp/lcaMarker"
declare LCA_PID_FILENAME="/var/run/lca.pid"
declare LCA_PY="/opt/sonus/sbx/scripts/lca/lca.py"
declare LCA_START_SH="/opt/sonus/sbx/scripts/lcaStart.sh"
declare LED_CONTROL_SH="/opt/sonus/sbx/scripts/ledControl.sh"
declare LINUXADMIN_AUTHORIZED_KEYS="/home/linuxadmin/.ssh/authorized_keys"
declare LIST_NON_SHA512_PASSWD_USERS_SH="/opt/sonus/sbx/sh/listNonSha512PasswdUsers.sh"
declare LIVE_UPGRADE_ACTIVE_KEY="/var/log/sonus/upgrade/liveUpgradeActive.key"
declare LOAD_CONFIG_MARKER_FILE="/opt/sonus/sbx/.configRestoreStaging/loadConfigMarker"
declare LOAD_CONFIG_TMP_MARKER_FILE="/var/log/sonus/tmp/loadConfigTmpMarker"
declare LOCK_NBI_SH="/opt/sonus/sbx/scripts/lockNBI.sh"
declare LOG_FILENAME_SWITCHOVER_AWS="/var/log/sonus/lca/AWSIPSwitchover.log"
declare LOG_FILENAME_SWITCHOVER_DVR="/var/log/sonus/lca/openstackDVRIpSwitchover.log"
declare LOG_FILENAME_SWITCHOVER_GCE="/var/log/sonus/lca/GCEIPSwitchover.log"
declare LOGROTATE_SH="/opt/sonus/sbx/scripts/logrotate.sh"
declare LOGROTATE_STATUS="/var/lib/logrotate/status"
declare LOGS_TO_HASH_MARKER="/var/log/sonus/tmp/filesToHash"
declare LSWU_COMMIT_PENDING="/opt/sonus/installUpgrade/log/lswuCommitPending"
declare LSWU_IN_PROGRESS="/opt/sonus/installUpgrade/log/lswuInProgress"
declare LSWU_REVERT_NOT_POSSIBLE="/opt/sonus/installUpgrade/log/.lswuRevertNotPossible"
declare LVINFO_PL="/home/common/lvinfo.pl"
declare MANAGE_NETWORK_ACCESS_SH="/opt/sonus/sbx/scripts/manageNetworkAccess.sh"
declare META_VAR_XML_FILENAME="/opt/sonus/sbx/lca/sonusMetaVariables.xml"
declare MGMT_INTF_XML_FILEPATH="/opt/sonus/sbx/tailf/var/confd/cdb/sonusMgmtIpInterface.xml"
declare MEMBERSHIP_JSON="/opt/sonus/sbx/serf/membership.json"
declare MISC_CONFIG_SWE_TXT="/opt/sonus/conf/swe/capacityEstimates/.miscConfigSwe.txt"
declare MODEL_PROCESS_NAMES_PM="/opt/sonus/sbx/scripts/ModelProcessNames.pm"
declare MODIFYRESTART_PL="/opt/sonus/sbx/scripts/modifyrestart.pl"
declare MONIT_CONFD_BONDING="/etc/monit/conf.d/bonding"
declare MOUNT_VOLUME_SH="/opt/sonus/bin/mountVolume.sh"
declare MPSTATSTEALWARNING="/opt/sonus/sbx/scripts/mpstatStealWarning"
declare NAME_CHANGE_MARKER="/var/log/sonus/sbx/.nameChangeMarker"
declare NEW_COREDUMPS="/var/log/sonus/sbx/coredump/newCoredumps"
declare NEW_NODE_CREATED_MARKER_FILE="/var/log/sonus/tmp/newNodeCreated.marker"
declare NODE_SERVICEID_MARKER_FILE="/var/log/sonus/tmp/nodeServiceId.marker"
declare NON_NP_MODE_ENV_FILE="/etc/container_environment/NON_NP_MODE"
declare NP_LOAD_ISSUE_AND_REBOOT="/opt/sonus/installUpgrade/log/npLoadIssueAndReboot"
declare NP_MEDIA_RES_CLEANUP="/opt/sonus/sbx/bin/npMediaResCleanup"
declare NP_MEM_DUMP="/opt/sonus/bin/np/np_mem_dump.pl"
declare NPMEM="/opt/sonus/bin/np/npmem"
declare NP_MODE_UPDATE="/opt/sonus/installUpgrade/log/npModeUpdate"
declare NP_STATS_LOG="/var/log/sonus/np/npStats.log"
declare NRS_U2K="/opt/sonus/sbx/utilities/nrs/bin/nrs_u2k"
declare NS_CONFIG_JSON_FILE="/opt/sonus/conf/swe/config/config.json"
declare NSPMGR="/opt/sonus/bin/nspmgr"
declare NSPMGR_STAT="/var/log/sonus/np/nspmgr_stat"
declare NTP_AUTOKEY_TOOL_SH="/opt/sonus/sbx/scripts/ntpAutokeyTool.sh"
declare NTP_MONITOR_SH="/opt/sonus/sbx/scripts/ntpMonitor.sh"
declare OAM_CONFIG_SH="/opt/sonus/sbx/scripts/oam-config.sh"
declare OAM_CONFIG_UPDATER_SH="/opt/sonus/sbx/scripts/oamConfigUpdater.sh"
declare OAM_REBOOT_SBC_IF_ACT_PROFILE_CHANGE="/opt/sonus/conf/swe/capacityEstimates/.oamRebootSbcIfActProfileChange"
declare OAM_SKIP_READING_ACT_FILES="/opt/sonus/conf/swe/capacityEstimates/.oamSkipActFiles"
declare OAM_SKIP_READING_CFG_FILES="/opt/sonus/conf/swe/capacityEstimates/.oamSkipCfgFiles"
declare OCTEON_DRV_KO="/opt/sonus/sbx/klm/octeon_drv.ko"
declare OCT_PCI_CSR="/opt/sonus/bin/np/oct-pci-csr"
declare OLD_LSWU_COMMIT_PENDING="/opt/sonus/lswuCommitPending"
declare OLD_REVERT_IN_PROGRESS="/opt/sonus/revertInProgress"
declare OLD_SBX_REVERT_PL="/opt/sonus/sbxRevert.pl"
declare OPERATOR_ACCESS_CONF="/var/log/sonus/evlog/config/ema/operatorAccess.conf"
declare ORACLE_NAME_CHANGE_SH="/opt/sonus/sbx/scripts/oracleNameChange.sh"
declare ORA_START_SH="/opt/sonus/sbx/scripts/oraStart.sh"
declare OS_UPGRADE_SH="/opt/sonus/staging/osUpgrade.sh"
declare OVFINSTALL_SH="/opt/sonus/sbx/scripts/ovfinstall.sh"
declare OPENSSL_CNF="/usr/lib/ssl/openssl.cnf"
declare PACKAGE_CONTENTS="/opt/sonus/staging/.packageContents"
declare PARTITION_LOG="/var/log/sonus/sbx/partition.log"
declare PARTITION_TOOL_SH="/usr/local/bin/partition_tool.sh"
declare PASSWD_SH="/opt/sonus/sbx/sh/passwd.sh"
declare PC_UPDATE_SUDOERS="/opt/sonus/sbx/scripts/pcUpdateSudoers.py"
declare PEER_DYNAMIC_HA_NEW_COMPS="/home/cnxipmadmin/peerDynamicHANewComps"
declare PEER_MODEL_UPDATE_PENDING="/opt/sonus/installUpgrade/log/peerModelUpdatePending"
declare PERFORM_MODEL_UPDATE="/opt/sonus/installUpgrade/log/performModelUpdate"
declare PERSONALITYTYPE_TXT="/opt/sonus/conf/personalitytype.txt"
declare PKT_RXTX_Q_TXT="/opt/sonus/conf/swe/capacityEstimates/.pktRxTxQ.txt"
declare PLATFORM_JSON_FILE="/opt/sonus/conf/platform.json"
declare PLAYBACK_STATUS_FILE="/opt/sonus/conf/.playback-status.tmp"
declare PLAYBACK_TRANSACTION_FILE_TXT="transaction-log.txt"
declare PLAYBACK_TRANSACTION_FILE_JSON="transaction-log.json"
declare PLAYBACK_TRANSACTION_FILE_LI_TXT="transaction-log-LI.txt"
declare PLAYBACK_TRANSACTION_FILE_LI_JSON="transaction-log-LI.json"
declare PNPS_DEBUG_SWE="/opt/sonus/bin/np/swe/pnpsDebugSwe"
declare PNPN_UNIX_SOCKET="/root/pnps_unix_sock"
declare POD_NETWORK_ANNOTATION="/etc/podinfo/network-annotations"
declare POD_RBAC_PATH="/var/run/secrets/kubernetes.io/serviceaccount/"
declare POD_UID="/etc/podinfo/uid"
declare POD_HUGEPAGE="/etc/podinfo/hugepage"
declare POD_VERSIONS="/opt/sonus/conf/pod_versions.txt"
declare POLICY_DB_SYNC_STATUS_SH="/opt/sonus/sbx/scripts/PolicyDBSyncStatus.sh"
declare POLICYPWD="/opt/sonus/sbx/psx/sql/policypwd"
declare POST_CLOUD_UPGRADE_OPERATIONS_MARKER="/var/log/sonus/tmp/.postCloudUpgradeOperationsMarker"
declare POST_CLOUD_UPGRADE_OPERATIONS_SH="/opt/sonus/sbx/scripts/postCloudUpgradeOperations.sh"
declare POSTGRES_CONFIG="/etc/postgresql"
declare POSTGRES_DATA="/home/postgresql/current"
declare POSTGRES_LIB="/usr/lib/postgresql"
declare POSTGRES_LOG="/var/log/postgresql"
declare POSTGRES_PG_HBA_CONF="/etc/postgresql/current/main/pg_hba.conf"
declare POSTGRES_SHARE="/usr/share/postgresql"
declare POSTGRES_STANDBY_SIGNAL="/home/postgresql/current/main/standby.signal"
declare POSTGRES_TRANSITION_FAILURE_MARKER="/var/log/sonus/tmp/.postgres_transition_marker"
declare PRE50_MARKER_TXT="/opt/sonus/staging/pre50Marker.txt"
declare PRE_INSTALL_CHECK_SH="/opt/sonus/staging/preInstallCheck.sh"
declare PRE_UPGRADE_CHECK_LOG="/var/log/sonus/upgrade/preChecks/preUpgradeCheck.log"
declare PROBE_CONTROLLER_SH="/opt/sonus/bin/probeController.sh"
declare PROCESS_NAMES_SH="/opt/sonus/sbx/scripts/process_names.sh"
declare PROMETHEUS_METRIC_COLLECTOR="/opt/sonus/sbx/scripts/metric_collector.py"
declare PROMETHEUS_METRIC_COLLECTOR_AND_EXPORTER="/opt/sonus/sbx/scripts/metricCollectorAndExporter.py"
declare PROMETHEUS_METRIC_EXPORTER="/opt/sonus/sbx/scripts/metric_exporter.py"
declare PRS_CPS_REBOOT="/var/log/sonus/tmp/.prsCpsReboot"
declare PRS_CPS_RESTART="/var/log/sonus/tmp/.prsCpsRestart"
declare PRS_DUMP_STATS="/var/log/sonus/tmp/.prsDumpStats"
declare PRS_PROCESS_CLEANUP_PL="/opt/sonus/sbx/scripts/prsProcessCleanup.pl"
declare PS_OS_SH="/opt/sonus/sbx/scripts/PsOS.sh"
declare PSX_GENERIC_KEY="/opt/sonus/sbx/psx/bin/.genericKey.dat"
declare PUBLIC_CLOUD_PRODUCT_CODE="/opt/sonus/conf/.productCode"
declare RAC_AGENT_LOG_FILE="/var/log/sonus/sbx/racAgent.log"
declare RAC_AGENT_FORMAT_NSC_TAKE_OVER_DATA_LOG="/var/log/sonus/sbx/racAgentFormatNscTakeOverData.log"
declare RAC_FLOATING_ID_TXT="/var/log/sonus/sbx/racFloatingId.txt"
declare RAC_FORMAT_TAKE_OVER_DATA_PY="/opt/sonus/sbx/scripts/formatRacTakeOverData.py"
declare RAC_NSC_TAKE_OVER_DATA_JSON="/var/log/sonus/sbx/racNscTakeOverData.json"
declare RAC_ROLE_TIMESTAMP_TXT="/var/log/sonus/sbx/racRoleTimestamp.txt"
declare RAC_ROLE_PY="/opt/sonus/sbx/scripts/getCnfRacRole.py"
declare RAC_ROLE_TXT="/var/log/sonus/sbx/racRole.txt"
declare REBOOT_COUNT="/var/log/sonus/sbx/.rebootCount"
declare REBOOTGUESTS_SH="/opt/sonus/sbx/scripts/rebootguests.sh"
declare RECONFIG_HW_PL="/opt/sonus/sbx/scripts/reconfigHw.pl"
declare REDUNDANCY_GROUP_JSON="/opt/sonus/sbx/serf/rg.json"
declare RE_GENERATE_SSH_KEYS_SH="/opt/sonus/sbx/scripts/reGenerateSshKeys.sh"
declare REG_CONFIG_FILE="/var/opt/sonus/sbcRegistration"
declare REMOVEARG_PL="/opt/sonus/sbx/scripts/removearg.pl"
declare REMOVECDB_SH="/opt/sonus/sbx/scripts/removecdb.sh"
declare REMOVEENV_PL="/opt/sonus/sbx/scripts/removeenv.pl"
declare REMOVE_SONUSDB_SH="/opt/sonus/sbx/scripts/removeSonusDb.sh"
declare REPLACE_ENC_KEYS_SH="/opt/sonus/sbx/scripts/replaceEncKeys.sh"
declare RESET_ENCRYPTED_STORE_DEFAULTS_SH="/opt/sonus/sbx/scripts/resetEncryptedStoreDefaults.sh"
declare RESET_LED_STATES_SH="/opt/sonus/sbx/scripts/resetLedStates.sh"
declare RESOLV_CONF="/etc/resolv.conf"
declare RESTART_ROLE_MARKER_FILE="/opt/sonus/installUpgrade/log/restartRoleMarkerFile"
declare RESTORE_CDB_SH="/opt/sonus/sbx/scripts/restoreCdb.sh"
declare RESTORE_CONFD_CONFIG_SH="/opt/sonus/sbx/scripts/restoreConfdConfig.sh"
declare RESTORE_CONFIG_FE_SH="/opt/sonus/sbx/scripts/restoreConfig_fe.sh"
declare RESTORE_SONUSDB_SH="/opt/sonus/sbx/scripts/restoreSonusDb.sh"
declare REVERT_IN_PROGRESS="/opt/sonus/installUpgrade/log/revertInProgress"
declare REVERT_UTIL_SH="/usr/local/bin/revertUtil.sh"
declare RSYSLOG_CONF="/etc/rsyslog.conf"
declare RUN_AGGREGATOR="/opt/sonus/sbx/scripts/runAggregator.sh"
declare RUN_CDRFILECHECK="/opt/sonus/sbx/scripts/oamCdrFileCheck.py"
declare RUN_DBSTATS_UPDATE="/opt/sonus/sbx/scripts/runDbUpdate.sh"
declare RUN_CLOUD_UPGRADE_OPERATIONS_ON_PEER_SH="/opt/sonus/sbx/scripts/runCloudUpgradeOperationsOnPeer.sh"
declare RUN_NTP_DATE_SH="/opt/sonus/bin/runNTPDate.sh"
declare RUN_OAM_SAVE_AND_ACTIVATE_SH="/opt/sonus/sbx/scripts/runOamSaveAndActivate.sh"
declare RUN_THIRD_PARTY_APPS_SH="/opt/sonus/sbx/scripts/runThirdPartyApps.sh"
declare RUN_TSHARK_SH="/opt/sonus/sbx/scripts/runTshark.sh"
declare S_BIT_MONIT_SH="/opt/sonus/sbx/scripts/sBitMonit.sh"
declare SAVE_CDB_SH="/opt/sonus/sbx/scripts/saveCdb.sh"
declare SAVE_CONFIG_FE_SH="/opt/sonus/sbx/scripts/saveConfig_fe.sh"
declare SAVE_CONFIG_VERSION_FILE="/var/log/sonus/tmp/playbackFilename.txt"
declare SAVE_CONFIG_VERSION_SH="/opt/sonus/sbx/scripts/saveConfigVersion.sh"
declare SAVE_DBS_SH="/opt/sonus/sbx/scripts/saveDBs.sh"
declare SAVE_NP_LOGS_SH="/opt/sonus/bin/np/saveNPLogs.sh"
declare SAVE_OC_LOGS_SH="/opt/sonus/sbx/scripts/saveOCLogs.sh"
declare SAVE_SONUS_DB_SH="/opt/sonus/sbx/scripts/saveSonusDb.sh"
declare SAVE_TAILF_LOGS_SH="/opt/sonus/sbx/scripts/saveTailfLogs.sh"
declare SBCCONF_FILE="/opt/sonus/conf/sbc.conf"
declare SBC_CONFIGMAP_JSON="/etc/config/sbcconfigmap.json"
declare CNF_USER_DATA_JSON="/etc/config/userData.json"
declare SBC_DIAGNOSTIC_SH="/opt/sonus/sbx/scripts/sbcDiagnostic.sh"
declare SBC_INTF_SH="/opt/sonus/sbx/scripts/sbcIntf.sh"
declare SBC_NODE_RENAME_SCRIPT="/opt/sonus/sbx/scripts/reconfigHa.pl"
declare SBC_PEER_RESOLVER_LOG_FILE="/var/log/sonus/sbcPodPeerResolver.log"
declare SBC_POD_ROLE_SELECTOR="/opt/sonus/bin/sbcPodRoleSelector.py"
declare SBC_ROLE_SELECTOR_LOG_FILE="/var/log/sonus/sbcPodRoleSelector.log"
declare SBCSFTP_MONIT_SH="/opt/sonus/bin/SbcSftpMonit.sh"
declare SBC_REBUILD_MARKER_FILE="/var/log/sonus/tmp/.sbc_rebuild_marker"
declare SBC_STARTUP_ERRORS_BANNER="/var/log/sonus/startuperrors/sbcStartupErrors.txt"
declare SBX_APPARMOR_SH="/opt/sonus/sbx/scripts/sbxAppArmor.sh"
declare SBX_AUTO_BACKUP_SH="/opt/sonus/sbx/scripts/sbxAutoBackup.sh"
declare SBX_BOND_SH="/opt/sonus/sbx/scripts/sbxBond.sh"
declare SBX_BOOT_AFTER_SYSTEM_REBOOT="/opt/sonus/sbxBootAfterSystemReboot"
declare SBX_CHECK_DRBD_BACKING_DEVICE_SH="/opt/sonus/sbx/scripts/sbxCheckDrbdBackingDevice.sh"
declare SBX_CLEANUP_MARKER="/tmp/sbxCleanupMarker"
declare SBX_CLEANUP_SH="/opt/sonus/sbx/scripts/sbxCleanup.sh"
declare SBX_CONFIG_UPDATER_SH="/opt/sonus/sbx/scripts/sbxConfigUpdater.sh"
declare SBXCONF_FILE="/opt/sonus/conf/sbx.conf"
declare SBX_CONF="/opt/sonus/sbx.conf"
declare SBX_DB_INSTALL_SH="/opt/sonus/sbx/scripts/sbxDbInstall.sh"
declare SBX_DRBD_STATUS_TXT="/var/log/sonus/tmp/sbxDrbdStatus.txt"
declare SBX_GET_PEER_IP_ADDR_SH="/opt/sonus/sbx/scripts/sbxGetPeerIpAddr.sh"
declare SBX_HW_IMAGE_BASED_UPGRADE_SH="/opt/sonus/staging/sbxHwImageBasedUpgrade.sh"
declare SBX_IMAGE_BASED_UPGRADE_SH="/opt/sonus/staging/sbxImageBasedUpgrade.sh"
declare SBX_INIT_OUT="/opt/sonus/staging/sbxInit.out"
declare SBX_INIT_SH="/opt/sonus/sbx/scripts/sbxInit.sh"
declare SBX_INSTALL_LOG="/var/log/sonus/install/sbx-install-log"
declare SBX_INSTALL_SH="/opt/sonus/staging/sbxInstall.sh"
declare SBX_INSTALL_UPGRADE_IN_PROGRESS="/tmp/.sbxInstallUpgradeInProgress"
declare SBX_INSTALL_UPGRADE_TXT="/var/log/sonus/cnxipm/admin/tmp/sbxInstallUpgrade.txt"
declare SBX_LI_KEY_SH="/opt/sonus/sbx/scripts/sbxLiKey.sh"
declare SBX_MALLOC_TRIM_STANDBY="/opt/sonus/sbx/scripts/sbxMallocTrim.sh"
declare SBX_MOUNT_VOLUME_MARKER="/opt/sonus/bin/.sbxMountVolumeMarker"
declare SBX_PEER_EXPECT_PL="/opt/sonus/staging/sbxPeerExpect.pl"
declare SBX_PEER_SPLIT_BRAIN_MARKER="/var/log/sonus/tmp/.sbxPeerSplitBrainMarker"
declare SBX_PEER_SPLIT_BRAIN_MODE_MARKER="/var/log/sonus/tmp/.sbxPeerSplitBrainModeMarker"
declare SBX_PERMISSION_CHECK_SH="/opt/sonus/sbx/scripts/sbxPermissionCheck.sh"
declare SBX_PERMISSION_DIR="var/log/permission"
declare SBX_PNPS_KO="/opt/sonus/lib/modules/sbx_pnps.ko"
declare SBX_PRE_CLEANUP_SH="/opt/sonus/sbx/scripts/sbxPreCleanup.sh"
declare SBX_REVERT_PL="/opt/sonus/installUpgrade/sbxRevert.pl"
declare SBX_REVERT_SH="/opt/sonus/installUpgrade/sbxRevert.sh"
declare SBX_SETUP_MIRROR_SUB_DIR_LINKS_SH="/opt/sonus/sbx/scripts/sbxSetupMirrorSubDirLinks.sh"
declare SBX_HMAC_SHA256SUMS="/opt/sonus/sbx/sbx.hmacSha256sums"
declare SBX_SPLIT_BRAIN_MARKER="/var/log/sonus/tmp/.sbxSplitBrainMarker"
declare SBX_START_SH="/opt/sonus/sbx/scripts/sbxStart.sh"
declare SBX_STARTUP_ERROR_LOG_PY="/opt/sonus/bin/sbxStartUpErrorLog.py"
declare SBX_UPDATE_OUT="/opt/sonus/staging/sbxUpdate.out"
declare SBX_VARLOG_TO_ROOT_MARKER="/var/log/sonus/.sbxVarlogToRootMarker"
declare SBX_VERIFY_PEER_CONNECTION_SH="/opt/sonus/sbx/scripts/sbxVerifyPeerConnection.sh"
declare SBXEMA_LOGROTATE_CONF="/opt/sonus/ema/sbxema/conf/logrotate.conf"
declare SC_CNF_SCALE_IN_STATE_TXT="/opt/sonus/metrics/sc_scale_in_state.txt"
declare SEC_RX_REQ_FILE="/opt/sonus/conf/swe/capacityEstimates/.secRxReq"
declare SELF_MODEL_UPDATE_PENDING="/opt/sonus/installUpgrade/log/selfModelUpdatePending"
declare SEND_SWITCHOVER_EVENT_MARKER="/var/log/sonus/tmp/.sendSwitchoverEventMarker"
declare SERF_BINARY="/opt/sonus/sbx/serf/serf"
declare SERF_DIR="/opt/sonus/sbx/serf"
declare SERF_EVENT_PROCESSOR_RESTART_CHECK_MARKER="/var/log/sonus/tmp/.serfEventProcessorRestartCheckMarker"
declare SERF_EVENT_PROCESSOR_RESTART_COUNT_MARKER="/var/log/sonus/tmp/.serfEventProcessorRestartCountMarker"
declare SERF_GET_SELF_PARAMS_PY="/opt/sonus/sbx/serf/serfGetSelfParams.py"
declare SERF_INDEX_MARKER_FILE="/opt/sonus/sbx/serf/.indexMarker"
declare SERF_MEMBERSHIP_CONFIG_FILENAME="/opt/sonus/sbx/serf/serf.conf.7947"
declare SERF_MEMBERSHIP_LOG="/var/log/sonus/sbx/serf/membership.log"
declare SERF_PLATFORM_CONFIG_FILENAME="/opt/sonus/sbx/serf/serf.conf"
declare SERF_REBOOT_CHECK_MARKER="/var/log/sonus/tmp/.serfRebootCheckMarker"
declare SERF_REBOOT_COUNT_MARKER="/opt/sonus/sbx/serf/serfRebootCountMarker"
declare SERF_RG_LOG="/var/log/sonus/sbx/serf/rg.log"
declare SERVICE_SH="/opt/sonus/sbx/scripts/service.sh"
declare SESSION_LOG_TRAP_FILE="/etc/rsyslog.d/.sessionLogTraps"
declare SET_EXTERNAL_AUTHENTICATION_SH="/opt/sonus/sbx/sh/setExternalAuthentication.sh"
declare SET_LOCAL_AUTHENTICATION_SH="/opt/sonus/sbx/sh/setLocalAuthentication.sh"
declare SET_TIME_ZONE_SH="/opt/sonus/sbx/scripts/setTimeZone.sh"
declare SETUP_NP_SH="/opt/sonus/bin/np/setupNP.sh"
declare SETUP_SWE_K8S_SH="/opt/sonus/bin/np/swe/setupSWe_k8s.sh"
declare SETUP_SWE_SH="/opt/sonus/bin/np/swe/setupSWe.sh"
declare SH_CONFD_CLI="/opt/sonus/sbx/Confd/sh/confd_cli"
declare SH_CONFD_CMD="/opt/sonus/sbx/Confd/sh/confd_cmd"
declare SHEILD_MGMT_PROCESS_SH="/opt/sonus/bin/swe/Shield_MgmtProcess.sh"
declare SHUTDOWN_SH="/opt/sonus/sbx/scripts/shutdown.sh"
declare SIGNAL_OUT="/var/log/sonus/tmp/signal.out"
declare SINGLE_HA_MISMATCH="/opt/sonus/sbx/.singleHAMismatch"
declare SL_ACL="/opt/sonus/securelink/sl-ACL"
declare SL_DISABLE_SH="/opt/sonus/securelink/sl-disable.sh"
declare SL_ENABLE_SH="/opt/sonus/securelink/sl-enable.sh"
declare SL_START_SH="/opt/sonus/securelink/sl-start.sh"
declare SL_STATUS_SH="/opt/sonus/securelink/sl-status.sh"
declare SL_STOP_SH="/opt/sonus/securelink/sl-stop.sh"
declare SMARTCTL_SH="/opt/sonus/sbx/scripts/smartctl.sh"
declare SOFT_RESTART_COUNT="/var/log/sonus/sbx/.softRestartCount"
declare SOFTWARE_UPGRADE_LOG="/var/log/sonus/upgrade/current/softwareUpgrade.log"
declare SOFTWARE_UPGRADE_STATUS="/var/log/sonus/upgrade/current/softwareUpgradeStatus"
declare SONUS_COMMON_UTILS_SH="/opt/sonus/bin/sonusCommonUtils.sh"
declare SONUS_CONVERT_POLICY_DB_SH="/opt/sonus/sbx/psx/sql/importExportSSDB.sh"
declare SONUS_DTMF_ANONYMIZATION_LOG_FILE="/var/log/sonus/dtmfAnonymization.log"
declare SONUS_DTMF_ANONYMIZATION_PREV_FILE="/var/log/sonus/sbx/.lastDTMFAnonymizedTrcFileName"
declare SONUS_DTMF_ANONYMIZATION_STATS_PID_FILE="/var/run/dtmfAnonymization.pid"
declare SONUS_EMA="/opt/sonus/ema/sonusEma"
declare SONUS_FAILLOG_OS="/var/log/sonus/sbx/linux/faillogOS"
declare SONUS_FAILLOG="/var/log/sonus/mirror/faillogdir"
declare SONUS_GPU_DATA_PY="/opt/sonus/bin/np/swe/gpuData.py"
declare SONUS_GPU_DATA_OUT_FILE="/opt/sonus/conf/gpuDataOut.xml"
declare SONUS_GPU_PROBE_FILE="/opt/sonus/conf/swe/capacityEstimates/.gpuProbe.txt"
declare SONUS_GRUB_MENU_BASE="/etc/grub.d/50_ribbon_sda"
declare SONUS_GRUB_MENU_PWD_FILE="/etc/grub.d/50_ribbon_pwd"
declare SONUS_GRUB_MENU_SDA1_FILE="/etc/grub.d/50_ribbon_sda1"
declare SONUS_GRUB_MENU_SDA6_FILE="/etc/grub.d/50_ribbon_sda6"
declare SONUS_GRUB_MENU_SDA7_FILE="/etc/grub.d/50_ribbon_sda7"
declare SONUS_INTERVAL_STATS_LOG_FILE="/var/log/sonus/interval-stats.log"
declare SONUS_INTERVAL_STATS_PID_FILE="/var/run/intervalstats.pid"
declare SONUS_INTERVAL_STATS_PREV_FILE="/var/log/sonus/sbx/.lastUntarFileName"
declare SONUS_MODIFY_STAGING_SH="/opt/sonus/bin/sonusModifyStaging.sh"
declare SONUS_NVIDIA_BIN_PATH="/opt/sonus/nvidia/bin"
declare SONUS_NVIDIA_LIB_PATH="/opt/sonus/nvidia/lib"
declare SONUS_PEER_CNX_EXPECT="/opt/sonus/sbx/scripts/sonusPeerCnx.expect"
declare SONUS_PEER_CNX_SH="/opt/sonus/sbx/scripts/sonusPeerCnx.sh"
declare SONUS_PEER_UPLOAD_EXPECT="/opt/sonus/sbx/scripts/sonusPeerUpload.expect"
declare SONUS_SBC_USER="/opt/sonus/sbx/bin/sonusSbcUser"
declare SONUS_SBX_REPAIR_SH="/opt/sonus/bin/sonusSbxRepair.sh"
declare SONUS_TASKS_SH="/opt/sonus/sbx/sh/sonusTasks.sh"
declare SONUS_TRC_LOG_FILE="/var/log/sonus/trc-anonimization.log"
declare SONUS_TRC_PID_FILE="/var/run/trc.pid"
declare SONUS_UPDATE_PEER_IPADR_LOG="/var/log/sonus/sbx/evlog/updatePeerIpAddr.log"
declare SONUS_UTILS_SH="/opt/sonus/sbx/scripts/sonusUtils.sh"
declare SONUSDB_START_SH="/etc/init.d/postgresql"
declare SONUSUDEV_RULES_JSON="/opt/sonus/conf/interface_mapping.json"
declare SQL_ARGS_FILE="/opt/sonus/sbx/psx/sql/SqlArgs.sql"
declare SSHAUTHTRIES_SH="/opt/sonus/sbx/scripts/sshAuthTries.sh"
declare STAGING_BUILDINFO="/opt/sonus/staging/.buildinfo"
declare STAGING_CHECK_DISK_PERFORMANCE_SH="/opt/sonus/staging/checkDiskPerformance.sh"
declare STAGING_CLOUD_DIAGS_PY="/opt/sonus/staging/cloud_diags.py"
declare STAGING_PARTITION_TOOL_SH="/opt/sonus/staging/partition_tool.sh"
declare STAGING_REVERT_UTIL_SH="/opt/sonus/staging/revertUtil.sh"
declare STAGING_SBX_REVERT_PL="/opt/sonus/staging/sbxRevert.pl"
declare STAGING_SBX_START_SH="/opt/sonus/staging/sbxStart.sh"
declare STAGING_SERVICE_SH="/opt/sonus/staging/service.sh"
declare STAGING_SONUS_COMMON_UTILS_SH="/opt/sonus/staging/sonusCommonUtils.sh"
declare STAGING_SONUS_UTILS_SH="/opt/sonus/staging/sonusUtils.sh"
declare STAGING_SWITCH_BOOT_SH="/opt/sonus/staging/switch_boot.sh"
declare STAGING_UPGRADE_MANAGER_PL="/opt/sonus/staging/upgradeManager.pl"
declare STAGING_UPDATE_SWE_CALLMIX_PY="/opt/sonus/staging/updateCallmix.py"
declare START_DSP_SH="/opt/sonus/bin/swe/startDSP.sh"
declare START_PGDB_SH="/opt/sonus/sbx/scripts/startPGDB.sh"
declare START_STOP_FILE_BEAT_SH="/opt/sonus/sbx/scripts/startStopFilebeat.sh"
declare STARTUP_LOG="/var/log/sonus/sbx/startup.log"
declare STATS_COLLECTOR_PY="/opt/sonus/sbx/scripts/pm_aggregator.py"
declare STATUS_UPDATER_PL="/opt/sonus/staging/statusUpdater.pl"
declare STEP_COUNTER_SH="/opt/sonus/staging/stepCounter.sh"
declare STOP_LWRESD_SH="/opt/sonus/sbx/scripts/stopLwresd.sh"
declare STUBPROC_PL="/opt/sonus/sbx/scripts/stubproc.pl"
declare SWE_APP_CONF_FILE="/opt/sonus/conf/swe/sweAppConf.txt"
declare SUDOERS="/etc/sudoers"
declare SUDOERS_CONFDADMIN="/etc/sudoers.d/sudoers-confdadmin"
declare SUDOERS_CNXIPMADMIN="/etc/sudoers.d/sudoers-cnxipmadmin"
declare SUDOERS_D="/etc/sudoers.d"
declare SUDOERS_LINUXADMIN="/etc/sudoers.d/sudoers-linuxadmin"
declare SUDOERS_SONUSADMIN="/etc/sudoers.d/sudoers-sonusadmin"
declare SUDOERS_WWW_DATA="/etc/sudoers.d/sudoers-www-data"
declare SWE_AZ_ACCEL_NIC_INFO_TXT="/opt/sonus/conf/swe/.az_accel_nic_info.txt"
declare SWE_AZ_INTERFACE_DATA_JSON="/opt/sonus/conf/intfMetaData.json"
declare SWE_CAPACITY_PY="/opt/sonus/bin/np/swe/sonusSweCapacity.py"
declare SWE_CFG_PROFILE_TXT="/opt/sonus/conf/swe/.sweCfgProfile.txt"
declare SWE_CGROUP_CPU_LIST_K8S="/opt/sonus/conf/cgroup/cpuset.cpus"
declare SWE_CGROUP_MOUNT_INFO="/proc/self/mountinfo"
declare SWE_CGROUP_MEM_STATS_K8S="/opt/sonus/conf/cgroup/memory.stat"
declare SWE_CGROUP_PID_MAX="/opt/sonus/conf/cgroup/pid.max"
declare SWE_CGROUP_SOFTLINK_PATH="/opt/sonus/conf/cgroup/"
declare SWE_CGROUP_STATS_PATH_TXT="/opt/sonus/conf/cgroupStatPath.txt"
declare SWE_CGROUP_TOTAL_MEM_K8S="/opt/sonus/conf/cgroup/memory.limit_in_bytes"
declare SWE_CGROUP_USED_MEM_UTIL_K8S="/opt/sonus/conf/cgroup/memory.usage_in_bytes"
declare SWE_CGROUP_USED_KMEM_UTIL_K8S="/opt/sonus/conf/cgroup/memory.kmem.usage_in_bytes"
declare SWE_CGROUP_VERSION_TXT="/opt/sonus/conf/cgroupVersion.txt"
declare SWE_CGROUP_VERSION_1_MEM_LIMIT="/sys/fs/cgroup/memory/memory.limit_in_bytes"
declare SWE_CGROUP_VERSION_1_MEM_STAT="/sys/fs/cgroup/memory/memory.stat"
declare SWE_CLI_CONF_DUMP_DIR="/opt/sonus/conf/swe/sweConfDump/"
declare SWE_CLI_CONF_FILE="/opt/sonus/conf/sweCli.conf"
declare SWE_CLI_CONF_LOG_FILE="/var/log/sonus/lca/applySWeCliConfig.log"
declare SWE_CLI_CONF_SH="/opt/sonus/sbx/scripts/applySWeConfig.sh"
declare SWE_CLOUD_TYPE_TXT="/var/log/sonus/tmp/cloudType.txt"
declare SWE_CONTAINER_ID_TXT="/opt/sonus/conf/containerId.txt"
declare SWE_CORE_DIST_K8S="/opt/sonus/conf/swe/.core_dist_k8s"
declare SWE_CPU_INFO_K8S="/etc/podinfo/cpu"
declare SWE_CPU_LIST_K8S="/opt/sonus/conf/swe/.cpulist_k8s"
declare SWE_INIT_MARKER_FILE="/opt/sonus/conf/swe/.init_done"
declare SWE_MEM_INFO_K8S="/etc/podinfo/memory"
declare SWE_MISC_INFO_TXT="/opt/sonus/conf/swe/capacityEstimates/.miscConfigSwe.txt"
declare SWE_NP="/opt/sonus/bin/np/swe/SWe_NP"
declare SWE_PFE_MODE_TXT="/opt/sonus/conf/swe/.pfe_mode.txt"
declare SWE_PKT_DUMP_LOG="/var/log/sonus/np/swePktdumpfile.log"
declare SWE_PORT_INFO_TXT="/opt/sonus/conf/swe/.port_config.txt"
declare SWE_PORT_MAP_TXT="/opt/sonus/conf/swe/.port_map.txt"
declare SWE_SBX_RECONFIG_PENDING="/opt/sonus/conf/sweSbxReconfigPending"
declare SWE_TSAN_NP_SUPPRESSIONS="/opt/sonus/bin/np/swe/np_suppressions.txt"
declare SWINFO_SH="/opt/sonus/sbx/scripts/swinfo.sh"
declare SWITCH_BOOT_SH="/usr/local/bin/switch_boot.sh"
declare SYNC_OAM_CONFIG_SH="/opt/sonus/sbx/scripts/syncOamConfig.sh"
declare SYSCTL_SH="/opt/sonus/sbx/scripts/sysctl.sh"
declare SYSLOG_UPDATED="/var/log/sonus/tmp/syslog_updated"
declare TAGS_JSON_FILE="/opt/sonus/sbx/serf/tags.json"
declare TAILF_CONFD="/opt/sonus/sbx/tailf/bin/confd"
declare TCP_PROBE_LISTENER="/opt/sonus/bin/tcpProbeListener.py"
declare THIRD_PARTY_APPS_TXT="/opt/sonus/conf/swe/thirdPartyApps.txt"
declare TMP_FORCEFSCK="/tmp/forcefsck"
declare TMP_OPENSSL_CSR_CNF="/var/log/sonus/tmp/openssl-csr.cnf"
declare TRACE_FILE_LIST="/var/log/sonus/sbx/coredump/traceFileList"
declare TRACEROUTE_UTILITY="/opt/sonus/bin/tracerouteUtility"
declare TRANSACTION_LOG_BUNDLENAME="/var/log/sonus/tmp/.trancationLogBundleName"
declare TRC_ANONYMIZATION_PREV_FILE="/var/log/sonus/sbx/.lastTrcAnonymizedFileName"
declare TRIGGER_CONTAINER_RESTART="/opt/sonus/sbx/scripts/containerRestart.sh"
declare TSAN_MARKER="/var/log/tsanBuild"
declare TSBC_ERR_MARKER="/var/log/sonus/tmp/.tsbcErrorLog"
declare TUNE2FS_SH="/opt/sonus/sbx/scripts/tune2fs.sh"
declare UDEV_RULES_FILE="/etc/udev/rules.d/70-persistent-net.rules"
declare UNLOCK_NBI_SH="/opt/sonus/sbx/scripts/unlockNBI.sh"
declare UNSTUBPROC_PL="/opt/sonus/sbx/scripts/unstubproc.pl"
declare UPDATE_APACHE_CONFIG_SH="/opt/sonus/sbx/sh/updateApacheConfig.sh"
declare UPDATE_DRBD_CONF_SH="/opt/sonus/sbx/scripts/updateDrbdConf.sh"
declare UPDATE_EMS_USERS_PY="/opt/sonus/sbx/scripts/updateEmsUsers.py"
declare UPDATE_GRUB_SH="/usr/local/bin/updateGrub.sh"
declare UPDATE_HOSTNAME_SH="/opt/sonus/sbx/scripts/updateHostname.sh"
declare UPDATE_NAME_SH="/opt/sonus/sbx/scripts/updateName.sh"
declare UPDATE_OWNER_AND_PERMISSIONS_SH="/opt/sonus/sbx/scripts/updateOwnerAndPermissions.sh"
declare UPDATE_PERSONALITY_PL="/opt/sonus/sbx/scripts/updatePersonality.pl"
declare UPDATE_RC_LOCAL_SH="/opt/sonus/sbx/scripts/updateRcLocal.sh"
declare UPDATE_RSYSLOG_CONF_SH="/opt/sonus/sbx/scripts/updateRsyslogConf.sh"
declare UPDATE_SOFTSBC_CONFIG_PL="/opt/sonus/sbx/scripts/updateSoftSBCConfig.pl"
declare UPDATE_SSH_PUBLIC_KEY_SH="/opt/sonus/sbx/scripts/updateSshPublicKey.sh"
declare SBX_UPDATE_SSH_CONFIG_SH="/opt/sonus/sbx/scripts/sbxUpdateSshConfig.sh"
declare UPGRADE_MANAGER_PL="/opt/sonus/sbx/scripts/upgradeManager.pl"
declare UPGRADE_MARKER="/opt/sonus/staging/upgradeMarker"
declare UPGRADE_OUT="/opt/sonus/staging/upgrade.out"
declare USERADD_SH="/opt/sonus/sbx/sh/useradd.sh"
declare USER_CONFIG_FLAG_FILE="/opt/sonus/sbx/.userConfig.FLAG"
declare USER_INPUT_PROMPT_JSON="/opt/sonus/conf/userInputPrompt.json"
declare USERDEL_SH="/opt/sonus/sbx/sh/userdel.sh"
declare USERMOD_SH="/opt/sonus/sbx/sh/usermod.sh"
declare VERIFY_HA_CONFIG_SH="/opt/sonus/sbx/scripts/verifyHaConfig.sh"
declare VIEW_CONFIGURATION_CHANGES_SH="/opt/sonus/sbx/scripts/viewConfigurationChanges.sh"
declare VMCONFIG_TXT="/opt/sonus/conf/swe/capacityEstimates/.vmConfig.txt"
declare VMCONFIG_OLD_TXT="/opt/sonus/conf/swe/capacityEstimates/.vmConfigOld.txt"
declare VMCONFIG_CHANGE_TXT="/opt/sonus/conf/swe/capacityEstimates/.vmConfigChange.txt"
declare VNFC_CURR_STATUS_CHECK_PL="/opt/sonus/sbx/scripts/sbcCurrAppStatusCheck.pl"
declare VNFC_STABLE_CALL_COUNT_PL="/opt/sonus/sbx/scripts/sbcStableCallCount.pl"
declare VNFC_SYNC_STATUS_CHECK_PL="/opt/sonus/sbx/scripts/sbcSyncStatusCheck.pl"
declare VNFM_DATA_UPDATE_JSON="/opt/sonus/conf/vnfmDataUpdate.json"
declare WRITE_FIPS_FSM_STATE_SH="/opt/sonus/sbx/scripts/writeFipsFSMState.sh"
declare ZEROIZE_KEYS_SH="/opt/sonus/sbx/scripts/zeroizeKeys.sh"
declare SONUS_RAMP_TLS_SECRET_DIR="/etc/tls/ramp"
declare SET_EMA_TLS_CERT_PROF_SH="/opt/sonus/sbx/sh/setEmaTlsProfCert.sh"
declare SBC_JOB_SCHEDULER_PY="/opt/sonus/bin/sbcJobScheduler.py"
declare ETC_INITD_SBCJOBSCHEDULER="/etc/init.d/sbcJobScheduler"
