#!/usr/bin/perl

BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/revert");
  unshift(@INC,"/opt/sonus/staging");
}

# command line processing
#use FileHandle;
#use File::Path;
use Getopt::Std;
#use File::Basename;
use Data::Dumper;
use sonusCommands;
use sbxCommonFunctions;
use sonusCommonFiles;

no warnings 'once';

my $getElem="unknown";
my $setElem="unknown";
my $rowElem="unknown";

my $peerArg="";

my $ceName=sbxCommonFunctions::getInstalledceName();
my $peerCeName=sbxCommonFunctions::getInstalledpeerCeName();

my $stagingDir="$SONUS_STAGING_DIR";

my $upgradeBaseDir="$SONUS_LOG_UPGRADE_DIR";
my $upgradeDir="$SONUS_LOG_UPGRADE_LATEST_DIR";
my $upgradeCheckDir="$SONUS_LOG_UPGRADE_PRECHECKS_DIR";
`$MKDIR -p $upgradeBaseDir`;

my $statusFile="$upgradeDir/softwareUpgradeStatus";
my $preCheckStatusFile="$upgradeCheckDir/preUpgradeCheckStatus";
my $checkArg="";
my $logFile="$upgradeBaseDir/statusUpdater.log";

if( ! -e $logFile )
{
    `$TOUCH $logFile`;
} 
# upgrade group not defined in older release
# give write permission to world.
# will be reverted after new OS is installed
if(!getgrnam("upgrade"))
{
    `$CHMOD 777 $logFile`;
}
else
{
    if( `$STAT -c "%A" $logFile | $HEAD -c 6 | $TAIL -c 1` ne "w" )
    {
        `$CHMOD g+w $logFile`;
    }
}

sub logMsg
{
  my $msg = shift;
  my $dateStr=`$DATE +"%b %d %T"`;
  chomp($dateStr);
  `$ECHO -e "$dateStr: $msg" >> $logFile`;
  #print("$dateStr: $msg\n");
}

sub printUsage()
{
  print("Usage: $0: -s <set Elem name> -v <Value to set> -g <get Elem name> -r <row Elem Name> -p -h -l -c -P\n");
  print("'-s' and '-g' are mutually exclusive\n");
  print("'-s' should have corresponding '-v'\n");
  print("'-p' specifies peer server info\n");
  print("'-r' specifies row element. i.e individual step name\n");
  print("'-l' update local log only\n");
  print("'-c' use pre-check status file\n");
  print("'-P' peer update only\n");
  print("row Elements can be:PreUpgradeChecks,DiskPartition,ImageUpgrade,BIOSUpgrade,Reboot,DBRestore,AppBringUp,PostUpgrade\n");
  print("Set and Get elements are: StartTime, EndTime,Status,Reason,TargetPackage,CurrentPackage,NumberOfSteps,CurrentStep,UpgradeStartTime,UpgradeCompleteTime,UpgradeStatus,LogFile\n");
  print("Set and Get options are mutually exclusive\n");
  print("Local-only and Peer-only options are mutually exclusive\n");
  print("Eg1: get current upgrade status: $0 -g UpgradeStatus\n");
  print("Eg2: set OSUpgrade Status to 'inProgress': $0 -s Status -v \"inProgress\" -r OSUpgrade\n"); 
  exit -1;
}

sub setElemValue
{
  my $setElem = shift;
  my $rowElem = shift;
  my $value = shift;
  my $ceName = shift;
  my $peerArg = shift;
  logMsg("setElemValue: setElem=$setElem, rowElem=$rowElem, value=$value,peerArg=$peerArg");
  if ( "$rowElem" eq "unknown" )
  {
    # Header Update
    `$SED -i 's/^$setElem=.*/$setElem=$value/' $statusFile`;
  }
  elsif ( "$rowElem" eq "preChecks" )
  {
    # preCheck row update
    if ( "$setElem" eq "Reason" )
    {
       `$SED -i "/$ceName/s/Reason=.*/Reason=$value/" $statusFile`;
    }
    else
    {
       `$SED -i "/$ceName/{;s/$setElem=[^,]*,/$setElem=$value,/;}" $statusFile`;
    }
  }
  else
  {
    # Row Update
    #`$ECHO "Inside raw update, raw=$rowElem" > /tmp/testing`;
    my $pattern='Step='.$rowElem;
    my $c = () = `$CAT $statusFile` =~ /$pattern/g;
    logMsg("c is=$c. Pattern:$pattern");
    if ( $c == 0 )
    {
       logMsg("c is=$c. $rowElem doesnt exist!. nothing to set.");
    }
    elsif ( $c > 2 )
    {
       my $currentStep=`$PERL $0 -g CurrentStep`;
       chomp($currentStep);
       my $currStepName=`$PERL $0 -g Step -r $currentStep $peerArg`;
       chomp($currStepName);
       logMsg("Multiple similar steps detected. Current Step is=$currStepName");
       if ( "$currStepName" ne "$rowElem" )
       {
         # rowElem is in next row.
         logMsg("rowElem can be in next row.");
         my $nextStep = $currentStep + 1;
         #print("Next step is=$nextStep\n");
         $currentStep = $nextStep;
         #my $nextStepName=`$PERL $0 -g Step -r $nextStep`;
         #chomp($nextStepName);
         #print("My next step name=$nextStepName\n");
       }
       #`$ECHO "CurrentStep is=$currentStep" >> /tmp/testing`;
       logMsg("Final values:ceName=$ceName,currentStep=$currentStep,rowElem=$rowElem,value=$value,statusFile=$statusFile");
       # Update the values.
       if ( "$setElem" eq "Reason" )
       {
         `$SED -i "/$ceName/{;/StepNo=$currentStep/{;/Step=$rowElem/s/Reason=.*/Reason=$value/;};}" $statusFile`;
       }
       else
       {
         `$SED -i "/$ceName/{;/StepNo=$currentStep/{;/Step=$rowElem/s/$setElem=[^,]*,/$setElem=$value,/;};}" $statusFile`;
       }
       if ( "$setElem" eq "Status" && "$value" eq "inProgress" )
       {
         # Update Current Step in header
         `$SED -i 's/^CurrentStep=.*/CurrentStep=$currentStep/' $statusFile`;
       }
       elsif ( "$setElem" eq "Status" && "$value" eq "failed" )
       {
         my $time=`date "+%FT%T%z"`; 
         chomp($time);
         `sed -i 's/^UpgradeCompleteTime=.*/UpgradeCompleteTime=$time/' $statusFile`;
         `$SED -i 's/^UpgradeStatus=.*/UpgradeStatus=upgradeFailed/' $statusFile`;
         `$RM -f $upgradeBaseDir/liveUpgradeActive.key`;
       }

    }
    else
    { 
       if ( "$setElem" eq "Reason" )
       {
          #`$SED -i "/$rowElem/s/Reason=.*/Reason=$value/" $statusFile`;
          `$SED -i "/$ceName/{;/Step=$rowElem/s/Reason=.*/Reason=$value/;}" $statusFile`;
       }
       else
       {
          #`$SED -i "/$rowElem/s/$setElem=[^,]*,/$setElem=$value,/" $statusFile`;
          `$SED -i "/$ceName/{;/Step=$rowElem/s/$setElem=[^,]*,/$setElem=$value,/;}" $statusFile`;
       }
       if ( "$setElem" eq "Status" && "$value" eq "inProgress" )
       {
         # Update Current Step in header
         my $currStep=`$PERL $0 -g StepNo -r $rowElem $peerArg`;
         chomp($currStep);
         logMsg("$setElem of $rowElem is inProgress. Updating CurrentStep as $currStep in header..");
         `$SED -i 's/^CurrentStep=.*/CurrentStep=$currStep/' $statusFile`;
       }
       elsif ( "$setElem" eq "Status" && "$value" eq "failed" )
       {
         # Update Status in header
         #my $myReason=`$PERL $0 -g Reason -r $rowElem $peerArg`;
         #chomp($myReason);
         my $time=`date "+%FT%T%z"`; 
         chomp($time);
         `sed -i 's/^UpgradeCompleteTime=.*/UpgradeCompleteTime=$time/' $statusFile`;
         `$SED -i 's/^UpgradeStatus=.*/UpgradeStatus=upgradeFailed/' $statusFile`;
         `$RM -f $upgradeBaseDir/liveUpgradeActive.key`;
         # TBD: call cleanup function to reset LSWU. 
       }
    }
  }
}
sub getElemValue
{
  my $getElem = shift;
  my $rowElem = shift;
  my $ceName = shift;
  logMsg("getElemValue: getElem=$getElem,rowElem=$rowElem,ceName=$ceName");
  if ( "$rowElem" eq "unknown" )
  {
    # Header Get
    my $elem = `$CAT $statusFile |$GREP ^$getElem | $AWK -F "=" '{print \$2}'`;
    chomp($elem);
    #print("Elem is $elem");
    return($elem);
  }
  elsif ( "$rowElem" eq "preChecks" )
  {
    my %hash1 = ();
    open(my $fh, $statusFile) || die "Unable to open the file";
    while ( my $line =<$fh> )
    {
      my %hash = ();
      if ($line =~ /CEcheckStatus/ )
      {
        chomp ($line);
        my $item;
        my($a, $b, $c, $d, $e) = split(",", $line);
        foreach $item ($b, $c,$d,$e)
        {
          my($first,$second) = split("=", $item);
          $hash{$first} = $second;
        }
        my($key, $value) = split("=", $a);
        $hash1{$value} = \%hash;
      }
    }
    #print Dumper(\%hash1);
    logMsg("$getElem on $ceName is=$hash1{\"$ceName\"}->{\"$getElem\"}");
    return($hash1{"$ceName"}->{"$getElem"});
  }
  else
  {
    # Row Get
    my %hash1 = ();
    my %hash2 = ();
    open(my $fh, $statusFile) || die "Unable to open the file";
    while ( my $line =<$fh> )
    {
      my %hash = ();
      if ($line =~ /StepNo/ && $line =~ /$ceName/ )
      {
        chomp ($line);
        my $item;
        my($a, $b, $c, $d, $e,$f,$g,$h) = split(",", $line);
        foreach $item ($b, $d, $e,$f,$g,$h)
        {
          my($first,$second) = split("=", $item);
          $hash{$first} = $second;
        }
        my($key1, $value1) = split("=", $a);
        my($key, $value) = split("=", $c);
        $hash1{$value} = \%hash;
        $hash2{$value1} = \%hash1;
      }
    }
    #print Dumper(\%hash2);
    #print Dumper(\%hash1);
    #print("from getElemValue(), getElem=$getElem  rowElem=$rowElem\n");
    #print("Value of $rowElem -> $getElem = $hash1{\"$rowElem\"}\n");
    if ($hash1{"$rowElem"})
    {
      logMsg("getElemValue: $rowElem -> $getElem = $hash1{\"$rowElem\"}->{\"$getElem\"}");
      return($hash1{"$rowElem"}->{"$getElem"});
    }
    else
    {
      # ceName->key can be StepNo instead of StepName.
      my %hash1 = ();
      my %hash2 = ();
      open(my $fh, $statusFile) || die "Unable to open the file";
      while ( my $line =<$fh> )
      {
        my %hash = ();
        if ($line =~ /StepNo/ && $line =~ /$ceName/ )
        {
        chomp ($line);
        my $item;
        my($a, $b, $c, $d, $e,$f,$g,$h) = split(",", $line);
        foreach $item ($c, $d, $e,$f,$g,$h)
        {
          my($first,$second) = split("=", $item);
          $hash{$first} = $second;
        }
        my($key1, $value1) = split("=", $a);
        my($key, $value) = split("=", $b);
        $hash1{$value} = \%hash;
        $hash2{$value1} = \%hash1;
        }
      }
      #print Dumper(\%hash1);
      logMsg("getElemValue: $rowElem ->Step  =$hash1{\"$rowElem\"}->{\"$getElem\"}");
      return($hash1{"$rowElem"}->{"$getElem"});
    }
  }
}

sub main()
{
  my $commandline = join( " ", $0, @ARGV);
  logMsg("==============================");
  logMsg("commandline=$commandline");
  getopts('g:s:r:v:chplP');

  if ($opt_g)
  {
    # Read call
    $getElem = $opt_g;
  }
  if ($opt_s)
  {
    # Write call
    $setElem = $opt_s;
  }
  if ($opt_r)
  {
    # Indicates step Element
    $rowElem = $opt_r;
  }
  if ($opt_v)
  {
    # Value of element to be set
    $value = $opt_v;
    #print("VALUE IS=$value\n");
    #print("VALUE IS(ARG)=$opt_v\n");
  }
  if ($opt_p)
  {
    # Get/Set Peer Info
    $peerArg="-p";
    $ceName="$peerCeName";
    #$statusFile = "$sbxUpgradeStatusMarker2";
  }
  if ($opt_h)
  {
    printUsage();
  }
  if ( ($opt_g) && ($opt_s) )
  {
    # Get and Set are mutually exclusive
    printUsage();
  }
  if ( ($opt_s) && !($opt_v))
  {
    # Set should be specified with a value
    printUsage();
  }
  if ( !($opt_s) && !($opt_g))
  {
    printUsage();
  }
  if ( ($opt_l) && ($opt_P) )
  {
    # local-only and peer-only are mutually exclusive
    printUsage();
  }
  if ($opt_c)
  {
    $statusFile="$preCheckStatusFile";
    $checkArg="-c";
  }

  if ( ! -e $statusFile )
  {
     logMsg("Upgrade Status file $statusFile doesnt exist. Not doing get/set operation[INFO].");
     exit(1);
  }
  if ( "$getElem" eq "unknown" )
  {
      # Set Operation
      if ( !($opt_P))
      {
        setElemValue($setElem,$rowElem,$value, $ceName, $peerArg);
      }
      #print("commandline='$commandline'\n");

      if ( !($opt_l))
      {
        my $peerCfg=1;
        my $peerIpAddr="";
        my $cnxExt="expect";
        my $haPortName="bond0";
        my $tmpPeerServer="";

        `$_IP addr show $haPortName 2> /dev/null | $GREP -q "inet "`;
        $peerCfg=$?;

        if ($peerCfg ne 0)
        {
           $haPortName="ha0";
           `$_IP addr show $haPortName  2> /dev/null | $GREP -q "inet "`;
           $peerCfg=$?;
        }

        if ( -e  "$SBXCONF_FILE" )
        {
           `$CAT $SBXCONF_FILE | $GREP ^peerCeName | $GREP -q none\$`;
           if ( $? eq 0 )
           {
              $peerCfg=1;
           }
        }

        if ( $peerCfg eq 0 )
        {
           if ( -e  "$SONUS_PEER_CNX_SH" )
           {
              $cnxExt="sh";
              $tmpPeerServer=`$_IP addr show $haPortName | $GREP "inet " | $AWK '{print \$2}' | $AWK -F/ '{print \$1}'`;
              chomp($tmpPeerServer);
              if ( "$tmpPeerServer" eq "169.254.99.1" )
              {
                 $peerIpAddr="169.254.88.1";
              }
              elsif ("$tmpPeerServer" eq "169.254.88.1" )
              {
                 $peerIpAddr="169.254.99.1";
              }
              else
              {
                 $peerCfg=1;
              }
           }
           elsif ( ! -e  "$SONUS_PEER_CNX_EXPECT" )
           {
              $peerCfg=1;
           }
        }

        if ($opt_p)
        {
          # Need to strip off '-p' while running on peer
          #my ($command1,$command2)=split("-p", $commandline);
          #$commandline=join(" ", $command1,$command2);
          `$SONUS_SBX_SCRIPT_DIR/sonusPeerCnx.$cnxExt $peerIpAddr $0 -r $rowElem -s $setElem -v "$value" $checkArg -l`;
        }
        else
        {
         #print("Peer command='perl $commandline -p -l'\n");
         #print("Peer command='perl $0 -r $rowElem -s $setElem -v "$value" -p -l'\n");
         `$SONUS_SBX_SCRIPT_DIR/sonusPeerCnx.$cnxExt $peerIpAddr $0 -r $rowElem -s $setElem -v "$value" -p $checkArg -l`;
        }
      }
  }
  else
  {
     # Get Operation
     #print("From main(), getElem=$getElem  rowElem=$rowElem\n");
     $elem = getElemValue($getElem,$rowElem, $ceName);
     print "$elem\n";
     return(0);
  }

}

main();
