#!/bin/bash
#############################################################
#
# Copyright (c) 2014 Sonus Networks, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# stepCounter.sh
#
# Durjay Mishra 
# 06/30/2014 
#
# Module Description:
# counts no of steps during upgrade from the log file..
#
#############################################################

# Sourcing Command Variables
if [ -e /opt/sonus/staging/sonusCommands.sh ] && [ -e /opt/sonus/staging/sonusCommonFiles.sh ]
then
    source /opt/sonus/staging/sonusCommands.sh
    source /opt/sonus/staging/sonusCommonFiles.sh
else
    source /opt/sonus/bin/sonusCommands.sh
    source /opt/sonus/bin/sonusCommonFiles.sh
fi

sbxUpgradeStepsCounter="$SONUS_STAGING_DIR/.sbxUpgradeStepsCounter"
create="n"
getStep="n"
incrementStep="n"
setMaxValue="n"
getMaxValue="n"
maxValue=""

usage()
{
  $INFO_LOG "usage: `$BASENAME $0` options

options:
 -c                          - creates the counter marker file 
 -g                          - get current step count 
 -i 			             - increment step counter  
 -m <max step count>         - sets maximum step count
 -l                          - get maximum step count
 -h                          - print help" 
}

while getopts "cgim:lh" OPTION
do
   case $OPTION in
   c)
      create="y"
      ;;
   g)
      getStep="y"
      ;;
   i)
      incrementStep="y"
      ;;
   m)
      setMaxValue="y"
      maxValue="$OPTARG"
      ;;
   l)
      getMaxValue="y"
      ;;
   h)
      usage
      exit 1
      ;;
   ?)
      usage
      exit 1
      ;;
   esac
done

if [ -e $sbxUpgradeStepsCounter ]; then
  . $sbxUpgradeStepsCounter
else
  CURR_STEP=0
  MAX_STEP=1
fi

if [ $create = "y" ]; then
  $ECHO "CURR_STEP=0" > $sbxUpgradeStepsCounter
  $ECHO "MAX_STEP=1" >> $sbxUpgradeStepsCounter
fi

if [ $getStep = "y" ]; then
  #$ECHO "Returning current step: $CURR_STEP"
  currStep=$CURR_STEP
  $currStep=${currStep//$'\n'/}  
  $ECHO $currStep 
  #exit $CURR_STEP
fi

if [ $incrementStep = "y" ]; then
  #$ECHO "Before Returning incremented step: $CURR_STEP"
  CURR_STEP=$((CURR_STEP+1))
  $ECHO "CURR_STEP=$CURR_STEP" > $sbxUpgradeStepsCounter
  $ECHO "MAX_STEP=$MAX_STEP" >> $sbxUpgradeStepsCounter
  #$ECHO "Returning incremented step: $CURR_STEP"
  $ECHO $CURR_STEP
  #exit $CURR_STEP
fi

if [ $setMaxValue = "y" ]; then
  $ECHO "CURR_STEP=$CURR_STEP" > $sbxUpgradeStepsCounter
  $ECHO "MAX_STEP=$maxValue" >> $sbxUpgradeStepsCounter
  $ECHO $CURR_STEP
  #exit $CURR_STEP
fi

if [ $getMaxValue = "y" ]; then
  #$ECHO "Returning max step: $MAX_STEP"
  $ECHO $MAX_STEP
  #exit $MAX_STEP
fi


