/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirProvider
implements WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog((String)DirProvider.class.getName());
    private WSDDDeployment deployment = null;
    private String configFile;
    private File dir;
    private static final String SERVER_CONFIG_FILE = "server-config.wsdd";

    public DirProvider(String basepath) throws ConfigurationException {
        this(basepath, SERVER_CONFIG_FILE);
    }

    public DirProvider(String basepath, String configFile) throws ConfigurationException {
        File dir = new File(basepath);
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", basepath));
        }
        this.dir = dir;
        this.configFile = configFile;
    }

    @Override
    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        this.deployment = new WSDDDeployment();
        WSDDGlobalConfiguration config = new WSDDGlobalConfiguration();
        config.setOptionsHashtable(new Hashtable());
        this.deployment.setGlobalConfiguration(config);
        File[] dirs = this.dir.listFiles(new DirFilter());
        for (int i = 0; i < dirs.length; ++i) {
            this.processWSDD(dirs[i]);
        }
        this.deployment.configureEngine(engine);
        engine.refreshGlobalOptions();
    }

    private void processWSDD(File dir) throws ConfigurationException {
        File file = new File(dir, this.configFile);
        if (!file.exists()) {
            return;
        }
        log.debug((Object)("Loading service configuration from file: " + file));
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument(in));
            doc.deploy(this.deployment);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
    }

    @Override
    public Handler getHandler(QName qname) throws ConfigurationException {
        return this.deployment.getHandler(qname);
    }

    @Override
    public SOAPService getService(QName qname) throws ConfigurationException {
        SOAPService service = this.deployment.getService(qname);
        if (service == null) {
            throw new ConfigurationException(Messages.getMessage("noService10", qname.toString()));
        }
        return service;
    }

    @Override
    public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
        return this.deployment.getServiceByNamespaceURI(namespace);
    }

    @Override
    public Handler getTransport(QName qname) throws ConfigurationException {
        return this.deployment.getTransport(qname);
    }

    @Override
    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.deployment.getTypeMappingRegistry();
    }

    @Override
    public Handler getGlobalRequest() throws ConfigurationException {
        return this.deployment.getGlobalRequest();
    }

    @Override
    public Handler getGlobalResponse() throws ConfigurationException {
        return this.deployment.getGlobalResponse();
    }

    @Override
    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration globalConfig = this.deployment.getGlobalConfiguration();
        if (globalConfig != null) {
            return globalConfig.getParametersTable();
        }
        return null;
    }

    @Override
    public Iterator getDeployedServices() throws ConfigurationException {
        return this.deployment.getDeployedServices();
    }

    @Override
    public List getRoles() {
        return this.deployment.getRoles();
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    }
}

