/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import jakarta.mail.internet.MimeMultipart;
import java.awt.Image;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.ImageDataHandlerDeserializer;
import org.apache.axis.encoding.ser.JAFDataHandlerDeserializer;
import org.apache.axis.encoding.ser.MimeMultipartDataHandlerDeserializer;
import org.apache.axis.encoding.ser.OctetStreamDataHandlerDeserializer;
import org.apache.axis.encoding.ser.PlainTextDataHandlerDeserializer;
import org.apache.axis.encoding.ser.SourceDataHandlerDeserializer;
import org.apache.commons.logging.Log;

public class JAFDataHandlerDeserializerFactory
extends BaseDeserializerFactory {
    protected static Log log = LogFactory.getLog(JAFDataHandlerDeserializerFactory.class.getName());

    public JAFDataHandlerDeserializerFactory(Class javaType, QName xmlType) {
        super(JAFDataHandlerDeserializerFactory.getDeserializerClass(javaType, xmlType), xmlType, javaType);
        log.debug((Object)("Enter/Exit: JAFDataHandlerDeserializerFactory(" + javaType + ", " + xmlType + ")"));
    }

    public JAFDataHandlerDeserializerFactory() {
        super(JAFDataHandlerDeserializer.class);
        log.debug((Object)"Enter/Exit: JAFDataHandlerDeserializerFactory()");
    }

    private static Class getDeserializerClass(Class javaType, QName xmlType) {
        Class deser = Image.class.isAssignableFrom(javaType) ? ImageDataHandlerDeserializer.class : (String.class.isAssignableFrom(javaType) ? PlainTextDataHandlerDeserializer.class : (Source.class.isAssignableFrom(javaType) ? SourceDataHandlerDeserializer.class : (MimeMultipart.class.isAssignableFrom(javaType) ? MimeMultipartDataHandlerDeserializer.class : (OctetStream.class.isAssignableFrom(javaType) ? OctetStreamDataHandlerDeserializer.class : JAFDataHandlerDeserializer.class))));
        return deser;
    }
}

