/*
 * Decompiled with CFR 0.152.
 */
package com.sonus.ems.lawfulintercept.liTarget.api.test;

import com.sonus.ems.lawfulintercept.ws.bind.LawfulInterceptTargetServiceSOAPBindingStub;
import com.sonus.ems.lawfulintercept.ws.model.EnabledEnum;
import com.sonus.ems.lawfulintercept.ws.model.ForwardedCallInterceptEnum;
import com.sonus.ems.lawfulintercept.ws.model.IngressCalltoWirelessSubEnum;
import com.sonus.ems.lawfulintercept.ws.model.InterceptCriteriaTypeEnum;
import com.sonus.ems.lawfulintercept.ws.model.InterceptionTypeEnum;
import com.sonus.ems.lawfulintercept.ws.model.LawfulInterceptTarget;
import com.sonus.ems.lawfulintercept.ws.model.LawfulInterceptTargetApiException;
import com.sonus.ems.lawfulintercept.ws.model.LawfulInterceptTargetKeys;
import jakarta.servlet.http.HttpServletRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis.message.SOAPHeaderElement;

public class LITestClientMgr {
    public static String mainUrl = new String("/liTargetProvisioning/services/");
    public LawfulInterceptTargetServiceSOAPBindingStub liApi = null;

    public String handleRequest(HttpServletRequest req) {
        String command = req.getParameter("commandAction");
        String criteriaType = req.getParameter("targetCriteriaType");
        req.getSession().setAttribute("criteriaType", (Object)criteriaType);
        String criteriaId = req.getParameter("targetCriteriaId");
        req.getSession().setAttribute("criteriaId", (Object)criteriaId);
        String interceptionType = req.getParameter("interceptionType");
        req.getSession().setAttribute("interceptionType", (Object)interceptionType);
        String forwardedCallIntercept = req.getParameter("forwardedCallIntercept");
        req.getSession().setAttribute("forwardedCallIntercept", (Object)forwardedCallIntercept);
        String ingressCalltoWirelessSub = req.getParameter("ingressCalltoWirelessSub");
        req.getSession().setAttribute("ingressCalltoWirelessSub", (Object)ingressCalltoWirelessSub);
        String enabledFlag = req.getParameter("enabledFlag");
        req.getSession().setAttribute("enabledFlag", (Object)enabledFlag);
        String tapIdStr = req.getParameter("tapIdStr");
        Integer tapId = null;
        if (tapIdStr != null && !tapIdStr.isEmpty()) {
            try {
                tapId = Integer.valueOf(tapIdStr);
            }
            catch (Exception ex) {
                String msg = "Lawful Intercept Target tapId: value : " + tapIdStr + " out of range: 1-2147483647.";
                this.logErrorMessage(ex, req, msg);
                return "";
            }
        }
        req.getSession().setAttribute("tapId", tapId);
        String dfGroupName = req.getParameter("dfGroupName");
        req.getSession().setAttribute("dfGroupName", (Object)dfGroupName);
        if ("create".equals(command)) {
            this.createLITarget(criteriaType, criteriaId, interceptionType, forwardedCallIntercept, ingressCalltoWirelessSub, enabledFlag, tapId, dfGroupName, req);
        } else if ("delete".equals(command)) {
            this.deleteLITarget(criteriaType, criteriaId, tapId, dfGroupName, req);
        } else if ("list".equals(command)) {
            this.listLITargets(req);
        } else if ("update".equals(command)) {
            this.updateLITarget(criteriaType, criteriaId, interceptionType, forwardedCallIntercept, ingressCalltoWirelessSub, enabledFlag, tapId, dfGroupName, req);
        } else if ("retrieve".equals(command)) {
            this.retrieveLITarget(criteriaType, criteriaId, tapId, dfGroupName, req);
        }
        return "";
    }

    public LITestClientMgr(HttpServletRequest req) {
        String hostname = req.getParameter("_server");
        if (hostname == null) {
            hostname = "localhost";
        }
        req.getSession().setAttribute("server", (Object)hostname);
        String port = req.getParameter("_port");
        if (port == null) {
            port = "80";
        }
        req.getSession().setAttribute("port", (Object)port);
        String username = req.getParameter("_username");
        if (username == null) {
            username = "calea";
        }
        req.getSession().setAttribute("username", (Object)username);
        String password = req.getParameter("_password");
        if (password == null) {
            password = "calea";
        }
        req.getSession().setAttribute("password", (Object)password);
        try {
            SOAPHeaderElement user = new SOAPHeaderElement("", "USER");
            user.setObjectValue((Object)username);
            SOAPHeaderElement passwd = new SOAPHeaderElement("", "PASSWORD");
            passwd.setObjectValue((Object)password);
            this.liApi = new LawfulInterceptTargetServiceSOAPBindingStub(this.makeUrl(hostname, port, "LawfulInterceptTargetService", req), null);
            this.liApi.setHeader(user);
            this.liApi.setHeader(passwd);
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in locating the LI services");
        }
    }

    public URL makeUrl(String hostname, String port, String serviceName, HttpServletRequest req) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append(hostname);
        sb.append(":");
        sb.append(port);
        sb.append(mainUrl);
        sb.append(serviceName);
        String urlStr = sb.toString();
        System.out.println("URL11 =" + urlStr);
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.logErrorMessage(e, req, "Exception in forming the URL");
        }
        return url;
    }

    public void createLITarget(String critType, String critId, String interceptionType, String forwardedCallIntercept, String ingressCalltoWirelessSub, String enabledFlag, Integer tapId, String dfGroupName, HttpServletRequest req) {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.fromString(critType));
        liTarget.setInterceptCriteriaId(critId);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.fromString(forwardedCallIntercept));
        liTarget.setEnabled(EnabledEnum.fromString(enabledFlag));
        if (tapId != null) {
            liTarget.setTapId(tapId);
        }
        liTarget.setDfGroupName(dfGroupName);
        try {
            this.liApi.createLawfulInterceptTarget(liTarget);
            req.getSession().setAttribute("result", (Object)"Operation succesfull");
        }
        catch (LawfulInterceptTargetApiException e) {
            this.logErrorMessage((Exception)((Object)e), req, "Exception in method createLITarget");
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in method createLITarget");
        }
    }

    public void deleteLITarget(String critType, String critId, Integer tapId, String dfGroupName, HttpServletRequest req) {
        LawfulInterceptTargetKeys liTarget = new LawfulInterceptTargetKeys();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.fromString(critType));
        liTarget.setInterceptCriteriaId(critId);
        try {
            if (tapId == null) {
                this.liApi.deleteLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            } else {
                liTarget.setTapId(tapId);
                this.liApi.deleteLawfulInterceptTargetV2(liTarget);
            }
            req.getSession().setAttribute("result", (Object)"Operation succesfull");
        }
        catch (LawfulInterceptTargetApiException e) {
            this.logErrorMessage((Exception)((Object)e), req, "Exception in method deleteLITarget");
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in method deleteLITarget");
        }
    }

    public void updateLITarget(String critType, String critId, String interceptionType, String forwardedCallIntercept, String ingressCalltoWirelessSub, String enabledFlag, Integer tapId, String dfGroupName, HttpServletRequest req) {
        LawfulInterceptTarget liTarget = new LawfulInterceptTarget();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.fromString(critType));
        liTarget.setInterceptCriteriaId(critId);
        liTarget.setForwardedCallIntercept(ForwardedCallInterceptEnum.fromString(forwardedCallIntercept));
        liTarget.setEnabled(EnabledEnum.fromString(enabledFlag));
        liTarget.setTapId(tapId);
        liTarget.setDfGroupName(dfGroupName);
        try {
            this.liApi.updateLawfulInterceptTarget(liTarget);
            req.getSession().setAttribute("result", (Object)"Operation succesfull");
        }
        catch (LawfulInterceptTargetApiException e) {
            this.logErrorMessage((Exception)((Object)e), req, "Exception in method updateLITarget");
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in method updateLITarget");
        }
    }

    public void retrieveLITarget(String critType, String critId, Integer tapId, String dfGroupName, HttpServletRequest req) {
        LawfulInterceptTargetKeys liTarget = new LawfulInterceptTargetKeys();
        liTarget.setInterceptCriteriaType(InterceptCriteriaTypeEnum.fromString(critType));
        liTarget.setInterceptCriteriaId(critId);
        try {
            LawfulInterceptTarget result;
            if (tapId == null) {
                result = this.liApi.retrieveLawfulInterceptTarget(liTarget.getInterceptCriteriaType(), liTarget.getInterceptCriteriaId());
            } else {
                liTarget.setTapId(tapId);
                result = this.liApi.retrieveLawfulInterceptTargetV2(liTarget);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<tr><th>Criteria Type</th><th>Criterai Id</th><th>Forwarded Call Intercept</th><th>Ingress Call to Wireless Sub</th><th>Enabled</th><th>Tap ID</th><th>Df Group Name</th></tr>");
            sb.append("<tr><td>");
            sb.append(result.getInterceptCriteriaType());
            sb.append("</td><td>");
            sb.append(result.getInterceptCriteriaId());
            sb.append("</td><td>");
            sb.append(result.getForwardedCallIntercept());
            sb.append("</td><td>");
            sb.append(result.getIngressCalltoWirelessSub());
            sb.append("</td><td>");
            sb.append(result.getEnabled());
            sb.append("</td><td>");
            sb.append(result.getTapId());
            sb.append("</td><td>");
            sb.append(result.getDfGroupName());
            sb.append("</td></tr>");
            req.getSession().setAttribute("result", (Object)sb.toString());
        }
        catch (LawfulInterceptTargetApiException e) {
            this.logErrorMessage((Exception)((Object)e), req, "Exception in method retrieveLITarget");
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in method retrieveLITarget");
        }
    }

    public void listLITargets(HttpServletRequest req) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<tr><th>Criteria Type</th><th>Criterai Id</th><th>Forwarded Call Intercept</th><th>Ingress Call to Wireless Sub</th><th>Enabled</th><th>Tap ID</th><th>Df Group Name</th></tr>");
            LawfulInterceptTarget[] listTargets = this.liApi.listLawfulInterceptTarget();
            System.out.println("length = " + listTargets.length);
            for (int i = 0; i < listTargets.length; ++i) {
                sb.append("<tr><td>");
                sb.append(listTargets[i].getInterceptCriteriaType());
                sb.append("</td><td>");
                sb.append(listTargets[i].getInterceptCriteriaId());
                sb.append("</td><td>");
                sb.append(listTargets[i].getForwardedCallIntercept());
                sb.append("</td><td>");
                sb.append(listTargets[i].getIngressCalltoWirelessSub());
                sb.append("</td><td>");
                sb.append(listTargets[i].getEnabled());
                sb.append("</td><td>");
                sb.append(listTargets[i].getTapId());
                sb.append("</td><td>");
                sb.append(listTargets[i].getDfGroupName());
                sb.append("</td></tr>");
            }
            req.getSession().setAttribute("result", (Object)sb.toString());
        }
        catch (LawfulInterceptTargetApiException e) {
            this.logErrorMessage((Exception)((Object)e), req, "Exception in method listLITargets");
        }
        catch (Exception e) {
            this.logErrorMessage(e, req, "Exception in method listLITargets");
        }
    }

    private void logErrorMessage(Exception e, HttpServletRequest req, String msg) {
        if (e instanceof LawfulInterceptTargetApiException) {
            LawfulInterceptTargetApiException ex = (LawfulInterceptTargetApiException)((Object)e);
            StringBuffer buffer = new StringBuffer();
            buffer.append(msg + " @error_message=" + ex.getErrorMessage() + " @error_code =" + ex.getErrorCode());
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            buffer.append("\n\n");
            buffer.append(writer.toString());
            req.getSession().setAttribute("result", (Object)buffer.toString().replaceAll("\\n", "<br>"));
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(msg + " @error_message=" + e.getMessage());
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            buffer.append("\n\n");
            buffer.append(writer.toString());
            req.getSession().setAttribute("result", (Object)buffer.toString().replaceAll("\\n", "<br>"));
        }
    }

    public static Object[] getInterceptCtiteriaTypes() {
        Field[] flds = InterceptCriteriaTypeEnum.class.getDeclaredFields();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].getType().getName().endsWith(".InterceptCriteriaTypeEnum")) continue;
            names.add(flds[i].getName());
        }
        return names.toArray();
    }

    public static Object[] getInterceptionTypes() {
        Field[] flds = InterceptionTypeEnum.class.getDeclaredFields();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].getType().getName().endsWith(".InterceptionTypeEnum")) continue;
            names.add(flds[i].getName());
        }
        return names.toArray();
    }

    public static Object[] getForwardedCallInterceptTypes() {
        Field[] flds = ForwardedCallInterceptEnum.class.getDeclaredFields();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].getType().getName().endsWith(".ForwardedCallInterceptEnum")) continue;
            names.add(flds[i].getName());
        }
        return names.toArray();
    }

    public static Object[] getIngressCalltoWirelessSubTypes() {
        Field[] flds = IngressCalltoWirelessSubEnum.class.getDeclaredFields();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].getType().getName().endsWith(".IngressCalltoWirelessSubEnum")) continue;
            names.add(flds[i].getName());
        }
        return names.toArray();
    }

    public static Object[] getEnabledTypes() {
        Field[] flds = EnabledEnum.class.getDeclaredFields();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < flds.length; ++i) {
            if (!flds[i].getType().getName().endsWith(".EnabledEnum")) continue;
            names.add(flds[i].getName());
        }
        return names.toArray();
    }
}

