/*
 * Decompiled with CFR 0.152.
 */
package com.sonus.ems.lawfulintercept.liTarget.api.test;

import com.sonus.ems.lawfulintercept.surveillance.client.bind.SurveillanceConfigBindingStub;
import com.sonus.ems.lawfulintercept.surveillance.client.common.CredentialsType;
import com.sonus.ems.lawfulintercept.surveillance.client.common.ErrorOptionType;
import com.sonus.ems.lawfulintercept.surveillance.client.config.Config;
import com.sonus.ems.lawfulintercept.surveillance.client.config.DfGroupNaturalKeyDO;
import com.sonus.ems.lawfulintercept.surveillance.client.config.DfNodeNameNaturalKeyDO;
import com.sonus.ems.lawfulintercept.surveillance.client.config.EditConfig;
import com.sonus.ems.lawfulintercept.surveillance.client.config.GetConfig;
import com.sonus.ems.lawfulintercept.surveillance.client.config.Reply;
import com.sonus.ems.lawfulintercept.surveillance.client.config.SurveillanceConfigCommand;
import com.sonus.ems.lawfulintercept.surveillance.client.config.SurveillanceConfigType;
import com.sonus.ems.lawfulintercept.surveillance.client.config.SurveillanceFilterType;
import com.sonus.ems.lawfulintercept.surveillance.client.config.TapDO;
import com.sonus.ems.lawfulintercept.surveillance.client.config.TapIdNaturalKeyDO;
import com.sonus.ems.lawfulintercept.surveillance.client.config.UserNaturalKeyDO;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.types.PositiveInteger;
import org.apache.log4j.Logger;

public class SurveillanceTestClientMgr {
    private static final String url = "/liTargetProvisioning/services/";
    private Logger logger = Logger.getLogger((String)SurveillanceTestClientMgr.class.getName());
    private SurveillanceConfigBindingStub surConfStub = null;

    public String handleRequest(HttpServletRequest req) {
        String addAll;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"handleRequest is invoked.");
        }
        String command = req.getParameter("commandAction");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("commandAction : " + command));
        }
        String userName = req.getParameter("userName");
        req.getSession().setAttribute("userName", (Object)userName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("userName : " + userName));
        }
        String password = req.getParameter("password");
        req.getSession().setAttribute("password", (Object)password);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("password : " + password));
        }
        String tapId = req.getParameter("tapId");
        req.getSession().setAttribute("tapId", (Object)tapId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("tapId : " + tapId));
        }
        String deviceName = req.getParameter("deviceName");
        req.getSession().setAttribute("deviceName", (Object)deviceName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("deviceName : " + deviceName));
        }
        String pni = req.getParameter("pni");
        req.getSession().setAttribute("pni", (Object)pni);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("pni : " + pni));
        }
        String txCcDfName = req.getParameter("txCcDfName");
        req.getSession().setAttribute("txCcDfName", (Object)txCcDfName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("txCcDfName : " + txCcDfName));
        }
        String txCcDfPort = req.getParameter("txCcDfPort");
        req.getSession().setAttribute("txCcDfPort", (Object)txCcDfPort);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("txCcDfPort : " + txCcDfPort));
        }
        String rxCcDfName = req.getParameter("rxCcDfName");
        req.getSession().setAttribute("rxCcDfName", (Object)rxCcDfName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("rxCcDfName : " + rxCcDfName));
        }
        String rxCcDfPort = req.getParameter("rxCcDfPort");
        req.getSession().setAttribute("rxCcDfPort", (Object)rxCcDfPort);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("rxCcDfPort : " + rxCcDfPort));
        }
        String targetId = req.getParameter("targetId");
        req.getSession().setAttribute("targetId", (Object)targetId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("targetId : " + targetId));
        }
        String cdDfGroupName = req.getParameter("cdDfGroupName");
        req.getSession().setAttribute("cdDfGroupName", (Object)cdDfGroupName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("cdDfGroupName : " + cdDfGroupName));
        }
        String tapIdGetReq = req.getParameter("tapIdGetReq");
        req.getSession().setAttribute("tapIdGetReq", (Object)tapIdGetReq);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("tapIdGetReq : " + tapIdGetReq));
        }
        String deviceNameGetReq = req.getParameter("deviceNameGetReq");
        req.getSession().setAttribute("deviceNameGetReq", (Object)deviceNameGetReq);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("deviceNameGetReq : " + deviceNameGetReq));
        }
        String pageIndex = req.getParameter("pageIndex");
        if (("getSurveillance".equals(command) || "getAllSurveillance".equals(command)) && pageIndex != null && !pageIndex.trim().isEmpty()) {
            try {
                new PositiveInteger(pageIndex);
            }
            catch (NumberFormatException ex) {
                req.getSession().setAttribute("pageIndex", (Object)pageIndex);
                req.getSession().setAttribute("result", (Object)"Invalid value for pageIndex");
                return "";
            }
        }
        req.getSession().setAttribute("pageIndex", (Object)pageIndex);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("pageIndex : " + pageIndex));
        }
        String pageSize = req.getParameter("pageSize");
        if (("getSurveillance".equals(command) || "getAllSurveillance".equals(command)) && pageSize != null && !pageSize.trim().isEmpty()) {
            try {
                new PositiveInteger(pageSize);
            }
            catch (NumberFormatException ex) {
                req.getSession().setAttribute("pageSize", (Object)pageSize);
                req.getSession().setAttribute("result", (Object)"Invalid value for pageSize");
                return "";
            }
        }
        req.getSession().setAttribute("pageSize", (Object)pageSize);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("pageSize : " + pageSize));
        }
        String countStr = req.getParameter("count");
        req.getSession().setAttribute("count", (Object)countStr);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("count : " + countStr));
        }
        if ((addAll = req.getParameter("addAll")) != null && Boolean.parseBoolean(addAll)) {
            int count = 0;
            try {
                count = Integer.valueOf(countStr);
            }
            catch (NumberFormatException ex) {
                req.getSession().setAttribute("result", (Object)"Invalid value for count");
                return "";
            }
            if (count > 1 && "addSurveillance".equals(command)) {
                this.addSurveillance(userName, password, tapId, deviceName, pni, txCcDfName, txCcDfPort, rxCcDfName, rxCcDfPort, targetId, cdDfGroupName, command, count, req);
            }
        } else if ("addSurveillance".equals(command) || "modifySurveillance".equals(command)) {
            this.editSurveillance(userName, password, tapId, deviceName, pni, txCcDfName, txCcDfPort, rxCcDfName, rxCcDfPort, targetId, cdDfGroupName, command, req);
        } else if ("removeSurveillance".equals(command)) {
            this.editSurveillance(userName, password, tapId, deviceName, null, null, null, null, null, null, null, command, req);
        } else if ("removeAllSurveillance".equals(command)) {
            this.editSurveillance(userName, password, null, deviceName, null, null, null, null, null, null, null, command, req);
        } else if ("getSurveillance".equals(command) || "getAllSurveillance".equals(command)) {
            this.getSurveillance(userName, password, deviceNameGetReq, tapIdGetReq, pageIndex, pageSize, req);
        }
        return "";
    }

    public SurveillanceTestClientMgr(HttpServletRequest req) {
        String protocol = req.getParameter("_protocol");
        if (protocol == null) {
            protocol = "http";
        }
        req.getSession().setAttribute("protocol", (Object)protocol);
        String hostname = req.getParameter("_server");
        if (hostname == null) {
            hostname = "localhost";
        }
        req.getSession().setAttribute("server", (Object)hostname);
        String port = req.getParameter("_port");
        if (port == null) {
            port = "80";
        }
        req.getSession().setAttribute("port", (Object)port);
        try {
            this.surConfStub = new SurveillanceConfigBindingStub(this.makeUrl(protocol, hostname, port, "surveillanceConfig", req), null);
        }
        catch (Exception e) {
            req.getSession().setAttribute("result", (Object)"Exception in locating the Surveillance Config Service");
        }
    }

    public URL makeUrl(String protocol, String hostname, String port, String serviceName, HttpServletRequest req) {
        StringBuffer sb = new StringBuffer();
        sb.append(protocol + "://");
        sb.append(hostname);
        sb.append(":");
        sb.append(port);
        sb.append(url);
        sb.append(serviceName);
        String urlStr = sb.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("URL : " + urlStr));
        }
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            req.getSession().setAttribute("result", (Object)"Exception in forming the URL");
        }
        return url;
    }

    private SurveillanceConfigType createSurvConfig(String deviceName, String pni, String txCcDfName, String txCcDfPort, String rxCcDfName, String rxCcDfPort, String targetId, String cdDfGroupName, String tapId, String command) {
        SurveillanceConfigType survConfig = new SurveillanceConfigType();
        TapDO tapDO = new TapDO();
        if (tapId != null && !tapId.trim().isEmpty()) {
            TapIdNaturalKeyDO tapKD = new TapIdNaturalKeyDO();
            tapKD.setName(tapId);
            tapDO.setTapId(tapKD);
        }
        tapDO.setDeviceName(deviceName);
        if (pni != null) {
            tapDO.setPni(Boolean.parseBoolean(pni));
        }
        if (cdDfGroupName != null && !cdDfGroupName.trim().isEmpty()) {
            DfGroupNaturalKeyDO dfGrpNKD = new DfGroupNaturalKeyDO();
            dfGrpNKD.setName(cdDfGroupName);
            tapDO.setCdDfGroupName(dfGrpNKD);
        }
        if (txCcDfName != null && !txCcDfName.trim().isEmpty()) {
            DfNodeNameNaturalKeyDO dftxCcDfName = new DfNodeNameNaturalKeyDO();
            dftxCcDfName.setName(txCcDfName);
            tapDO.setTxCcDfName(dftxCcDfName);
        }
        if (txCcDfPort != null && !txCcDfPort.trim().isEmpty()) {
            tapDO.setTxCcDfPort(txCcDfPort);
        }
        if (rxCcDfName != null && !rxCcDfName.trim().isEmpty()) {
            DfNodeNameNaturalKeyDO dfrxCcDfName = new DfNodeNameNaturalKeyDO();
            dfrxCcDfName.setName(rxCcDfName);
            tapDO.setRxCcDfName(dfrxCcDfName);
        }
        if (rxCcDfPort != null && !rxCcDfPort.trim().isEmpty()) {
            tapDO.setRxCcDfPort(rxCcDfPort);
        }
        if (targetId != null && !targetId.trim().isEmpty()) {
            UserNaturalKeyDO targetKD = new UserNaturalKeyDO();
            targetKD.setName(targetId);
            tapDO.setTargetId(targetKD);
        }
        survConfig.setSurveillance(tapDO);
        survConfig.setCommand(SurveillanceConfigCommand.fromString(command));
        return survConfig;
    }

    private CredentialsType createCredentialsType(String userName, String password) {
        CredentialsType credential = new CredentialsType();
        credential.setUser(userName);
        credential.setPassword(password);
        return credential;
    }

    private void editSurveillance(String userName, String password, String tapId, String deviceName, String pni, String txCcDfName, String txCcDfPort, String rxCcDfName, String rxCcDfPort, String targetId, String cdDfGroupName, String command, HttpServletRequest req) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"editSurveillance is invoked.");
        }
        EditConfig editConfigRequest = new EditConfig();
        Config config = new Config();
        config.setCredential(this.createCredentialsType(userName, password));
        SurveillanceConfigType surveillanceConfig = this.createSurvConfig(deviceName, pni, txCcDfName, txCcDfPort, rxCcDfName, rxCcDfPort, targetId, cdDfGroupName, tapId, command);
        SurveillanceConfigType[] configArray = new SurveillanceConfigType[]{surveillanceConfig};
        config.setSurveillanceConfig(configArray);
        editConfigRequest.setConfig(config);
        ErrorOptionType errorOption = ErrorOptionType.fromValue("ignore-error");
        editConfigRequest.setErrorOption(errorOption);
        try {
            Reply reply = this.surConfStub.editSurveillanceConfig(editConfigRequest);
            if (reply.getOk() != null && !reply.getOk().isEmpty()) {
                req.getSession().setAttribute("result", (Object)(command + " is successful"));
            } else {
                req.getSession().setAttribute("result", (Object)this.createErrorString(reply).toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception : ", (Throwable)e);
            req.getSession().setAttribute("result", (Object)("Exception while adding surveillance :" + e.getMessage()));
        }
    }

    private void addSurveillance(String userName, String password, String tapId, String deviceName, String pni, String txCcDfName, String txCcDfPort, String rxCcDfName, String rxCcDfPort, String targetId, String cdDfGroupName, String command, int count, HttpServletRequest req) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"editSurveillance is invoked.");
        }
        EditConfig editConfigRequest = new EditConfig();
        Config config = new Config();
        config.setCredential(this.createCredentialsType(userName, password));
        StringBuffer sb = new StringBuffer();
        for (int row = 1; row <= count; ++row) {
            String tapIdIn = tapId != null ? tapId + row : "t" + row;
            String targetIdIn = targetId != null ? targetId + String.valueOf(row) : String.valueOf(row) + "@rbbn.com";
            SurveillanceConfigType surveillanceConfig = this.createSurvConfig(deviceName, pni, txCcDfName, txCcDfPort, rxCcDfName, rxCcDfPort, targetIdIn, cdDfGroupName, tapIdIn, command);
            SurveillanceConfigType[] configArray = new SurveillanceConfigType[]{surveillanceConfig};
            config.setSurveillanceConfig(configArray);
            editConfigRequest.setConfig(config);
            ErrorOptionType errorOption = ErrorOptionType.fromValue("ignore-error");
            editConfigRequest.setErrorOption(errorOption);
            try {
                Reply reply = this.surConfStub.editSurveillanceConfig(editConfigRequest);
                if (reply.getOk() != null && !reply.getOk().isEmpty()) continue;
                sb.append("Add Surveillance failed for tapId : " + tapIdIn + reply.getError() != null ? reply.getError().getErrorMessage() : "");
                sb.append(System.getProperty("line.separator"));
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception while adding bulk : ", (Throwable)e);
                sb.append("Add Surveillance failed for tapId : " + tapIdIn + e.getMessage());
                sb.append(System.getProperty("line.separator"));
            }
        }
        if (sb.length() > 1) {
            req.getSession().setAttribute("result", (Object)sb.toString());
        } else {
            req.getSession().setAttribute("result", (Object)"Create Bulk is successful");
        }
    }

    private void getSurveillance(String userName, String password, String deviceName, String tapId, String pageIndex, String pageSize, HttpServletRequest req) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getSurveillance is invoked.");
        }
        GetConfig getConfigReq = new GetConfig();
        getConfigReq.setCredential(this.createCredentialsType(userName, password));
        getConfigReq.setSurveillanceFilter(this.createSurveillanceFilter(deviceName, tapId, pageIndex, pageSize));
        try {
            Reply reply = this.surConfStub.getSurveillanceConfig(getConfigReq);
            if (reply.getOk() != null && !reply.getOk().isEmpty()) {
                TapDO[] tapDOList = reply.getData().getSurveillanceConfig();
                StringBuffer sb = new StringBuffer();
                if (tapDOList != null && tapDOList.length >= 1) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Length of list : " + tapDOList.length));
                    }
                    sb.append("Number of Surveillances : " + tapDOList.length + "\n");
                    sb.append("<tr><th>Device Name</th><th>Tap Id</th><th>PNI</th><th>txCcDfName</th><th>txCcDfPort</th><th>rxCcDfName</th><th>rxCcDfPort</th><th>Target ID</th><th>cdDfGroupName</th></tr>");
                    for (TapDO tapDO : tapDOList) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("TapDO : " + tapDO));
                        }
                        sb.append("<tr><td>");
                        sb.append(tapDO.getDeviceName());
                        sb.append("</td><td>");
                        sb.append(tapDO.getTapId() != null ? tapDO.getTapId().getName() : "");
                        sb.append("</td><td>");
                        sb.append(tapDO.isPni());
                        sb.append("</td><td>");
                        sb.append(tapDO.getTxCcDfName() != null ? tapDO.getTxCcDfName().getName() : "");
                        sb.append("</td><td>");
                        sb.append(tapDO.getTxCcDfPort());
                        sb.append("</td><td>");
                        sb.append(tapDO.getRxCcDfName() != null ? tapDO.getRxCcDfName().getName() : "");
                        sb.append("</td><td>");
                        sb.append(tapDO.getRxCcDfPort());
                        sb.append("</td><td>");
                        sb.append(tapDO.getTargetId() != null ? tapDO.getTargetId().getName() : "");
                        sb.append("</td><td>");
                        sb.append(tapDO.getCdDfGroupName() != null ? tapDO.getCdDfGroupName().getName() : "");
                        sb.append("</td></tr>");
                    }
                    req.getSession().setAttribute("result", (Object)sb.toString());
                } else {
                    sb.append("Number of Surveillance : 0  \n");
                    req.getSession().setAttribute("result", (Object)sb.toString());
                }
            } else {
                req.getSession().setAttribute("result", (Object)this.createErrorString(reply).toString());
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception while getting surveillance : ", (Throwable)ex);
            req.getSession().setAttribute("result", (Object)("Exception while getting surveillance :" + ex.getMessage()));
        }
    }

    private SurveillanceFilterType createSurveillanceFilter(String deviceName, String tapId, String pageIndex, String pageSize) {
        SurveillanceFilterType filter = new SurveillanceFilterType();
        filter.setDeviceName(deviceName);
        if (tapId != null) {
            TapIdNaturalKeyDO tapKD = new TapIdNaturalKeyDO();
            tapKD.setName(tapId);
            filter.setTapId(tapKD);
        }
        if (pageIndex != null && !pageIndex.isEmpty()) {
            filter.setPageIndex(new PositiveInteger(pageIndex.trim()));
        }
        if (pageSize != null && !pageSize.isEmpty()) {
            filter.setPageSize(new PositiveInteger(pageSize.trim()));
        }
        return filter;
    }

    private StringBuffer createErrorString(Reply reply) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td>Error Number </td><td>" + reply.getError().getErrorNumber() + "</td></tr>");
        sb.append("<tr><td>Error Tag </td><td>" + reply.getError().getErrorTag() + "</td></tr>");
        sb.append("<tr><td>Error Message </td><td>" + reply.getError().getErrorMessage() + "</td></tr>");
        sb.append("<tr><td>Error Type </td><td>" + reply.getError().getErrorTtype() + "</td></tr>");
        sb.append("<tr><td>Error Severity </td><td>" + reply.getError().getErrorSeverity() + "</td></tr>");
        return sb;
    }
}

