#!/usr/bin/perl -w

#############################################################
##
## Copyright (c) 2019 Ribbon Communication, Inc.
##
## All Rights Reserved.
## Confidential and Proprietary.
##
## checkSyncStatus.pl
## 06 Dec 2019.
##
## Module Description:
##
## This script contains utilities to be used during VNFC
## automated software upgrade process.
##
##
## This script doesn't contain main() and shouldn't be invoked on it's own.
##
##############################################################
BEGIN {
  # locate packages in places other than the standard perl path
  unshift(@INC,"/opt/sonus/bin");
  unshift(@INC,"/opt/sonus/staging");
}

use sonusCommands;
use sbxCommonFunctions;
use sonusCommonFiles;

my $operation="sync status check";
my $result="success";
my $reason="none";
my $retryAfter = 0;
my $exitCode=0;
my $haMode=`$SWINFO_SH -l | $GREP '^HA mode:' | $CUT -d ":" -f 2 | $SED 's/^[ \t]*//'`;

sub runCliCommandLocal
{
  my $cmd = shift;
  my $out;

  $out=`($SLEEP 1; $ECHO -e "set screen width 512\n $cmd \n") | $SUDO /opt/sonus/sbx/tailf/bin/confd_cli -u admin --noaaa --noninteractive`; # sudoers-www-data

  return($out);
}

sub checkSbcSyncStatus
{
  my $syncStatus="syncCompleted";
  my $cmd = "show table system syncStatus";

  my $out = runCliCommandLocal("$cmd");

  my @lines = split /\n/, $out;

  foreach my $line (@lines)
  {
    if ( $line =~ /Metavar Data/ && ($line !~ /syncCompleted/ && $line !~ /unprotectedRunningStandby/) )
    {
       $syncStatus="unprotected";
    }
    elsif ( $line =~ /Registration Data/ && ($line !~ /syncCompleted/ && $line !~ /unprotectedRunningStandby/))
    {
       $syncStatus="unprotected";
    }
    elsif ( $line =~ /error/ )
    {
       $syncStatus="unprotected";
    }
  }

  if( $syncStatus eq "unprotected" )
  {
       return 0;
  }
  else
  {
       return 1;
  }
}

sub checkSbc1to1SyncStatus
{
  my $syncStatus="syncCompleted";
  my $cmd = "show table system syncStatus";

  my $out = runCliCommandLocal("$cmd");

  my @lines = split /\n/, $out;

  foreach my $line (@lines)
  {
    if ( $line =~ /Metavar Data/ && ($line !~ /syncCompleted/ && $line !~ /unprotectedRunningStandby/) )
    {
       $syncStatus="unprotected";
    }
    elsif ( $line =~ /Registration Data/ && ($line !~ /syncCompleted/ && $line !~ /unprotectedRunningStandby/))
    {
       $syncStatus="unprotected";
    }
    elsif ( $line =~ /Policy Data/ && ($line !~ /syncCompleted/ && $line !~ /unprotectedRunningStandby/))
    {
       $syncStatus="unprotected";
    } 
    elsif ( $line =~ /error/ )
    {
       $syncStatus="unprotected";
    }
  }

  if( $syncStatus eq "unprotected" )
  {
       return 0;
  }
  else
  {
       return 1;
  }
}

sub checkVnfcStableCallCount
{
  my $cmd = "show status global callCountStatus";
  my $out = runCliCommandLocal("$cmd");
  my $stableCallCount = 0;

  my @lines = split /\n/, $out;
  foreach my $line (@lines)
  {
     if( $line =~ /stableCalls  / )
     {
        $stableCallCount = `$ECHO "$line" | $AWK '{print \$2}'`;
        $stableCallCount =~ s/[^0-9]//g;
     }
  }

  return $stableCallCount;
}

sub checkHAStatus()
{
  my $cmd = "show status system rgStatus";
  my $out = runCliCommandLocal("$cmd");
  my $peerCount = 0;

  my @lines = split /\n/, $out;
  foreach my $line (@lines)
  {
    if( $line =~ /actualCeName  / )
     {
        $peerCount++;
     }
  }
  return $peerCount;
}

sub checkSyncStatusResult
{
  my $stableCallNum = checkVnfcStableCallCount();
  my $numPeer = checkHAStatus();
  my $numCallSyncPerSecond = 1200;

  if ( $numPeer > 1 )
  {
       if( 0 eq checkSbcSyncStatus() )
       {
           use integer;
           $retryAfter = int($stableCallNum) / int($numCallSyncPerSecond);
           $result = "failure";
           $reason = "sync in progress";
           $exitCode = 1;
       }
  }
}

sub checkSyncStatus1to1Result
{
  my $stableCallNum = checkVnfcStableCallCount();
  my $peerCeName=sbxCommonFunctions::getInstalledpeerCeName();
  my $numCallSyncPerSecond = 1200;

  if ( $peerCeName !~ /none/ )
  {
       if( 0 eq checkSbc1to1SyncStatus() )
       {
           use integer;
           $retryAfter = int($stableCallNum) / int($numCallSyncPerSecond);
           $result = "failure";
           $reason = "sync in progress";
           $exitCode = 1;
       }
  } 

}

chomp($haMode);
if ( $haMode ne "1to1" )
{
    checkSyncStatusResult();
}
else
{
    checkSyncStatus1to1Result();
}
print "Operation: $operation\n";
print "Result: $result\n";
print "Reason: $reason\n";
print "RetryAfter: $retryAfter\n";
exit $exitCode;

