#!/bin/bash
#############################################################
#
# Copyright (c) 2016 Sonus Networks, Inc.
#
# All Rights Reserved.
# Confidential and Proprietary.
#
# Module Description:
#    Wrapper script for sudo commands.
#    Limits functionality exposed to sudo users
#############################################################
# Sourcing Command Variables
source /opt/sonus/bin/sonusCommands.sh
source /opt/sonus/bin/sonusCommonFiles.sh

PROG=${0##*/}
configFile=/etc/rc.local

usage()
{
    $ECHO "$@ "
    $ECHO "usage: $PROG [-h] <-c | -i <script> <package> >"
    $ECHO "  -c : clear startUpgrade from $configFile"
    $ECHO "  -i : installs startUpgrade to $configFile"
    $ECHO "  -h : This usage help."
    $ECHO ""
    $ECHO " e.g.: $PROG -c"
    $ECHO " e.g.: $PROG -i $SONUS_STAGING_DIR/upgradeManager.pl sbc-V05.01.00-A417.x86_64.tar.gz"
    exit
}

error()
{
    $LOGGER -t $PROG "error: $1"
    exit 1
}

clearUpgrade()
{
    $SED -i "/startUpgrade/d" $configFile
    exit $?
}

installUpgrade()
{
    local script=$1
    local package=$2
    [[ -z $script ]] && error "script not provided."
    [[ -z $package ]] && error "package not provided."

    $SED -i "s,^exit,$PERL $script startUpgrade $package rc_local \\n&," $configFile
    exit $?
}

while getopts hci o
do
    case $o in
        i) installUpgradeFlag=1 ;;
        c) clearUpgrade ;;
        h) usage ;;
        \?) usage "Unrecognized switch"
    esac
done

shift $(expr $OPTIND - 1)

[[ ! -z $installUpgradeFlag ]] && installUpgrade $1 $2
usage
