/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleListDeserializer;
import org.apache.axis.utils.JavaUtils;

public class SimpleListDeserializerFactory
extends BaseDeserializerFactory {
    private static final Class[] STRING_CLASS = new Class[]{String.class};
    private final Class clazzType;
    private transient Constructor constructor = null;

    public SimpleListDeserializerFactory(Class javaType, QName xmlType) {
        super(SimpleListDeserializer.class, xmlType, javaType.getComponentType());
        this.clazzType = javaType;
        Class<?> componentType = javaType.getComponentType();
        try {
            if (!componentType.isPrimitive()) {
                this.constructor = componentType.getDeclaredConstructor(STRING_CLASS);
            } else {
                Class wrapper = JavaUtils.getWrapperClass(componentType);
                if (wrapper != null) {
                    this.constructor = wrapper.getDeclaredConstructor(STRING_CLASS);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
        if (this.javaType == Object.class) {
            return null;
        }
        SimpleListDeserializer deser = (SimpleListDeserializer)super.getDeserializerAs(mechanismType);
        if (deser != null) {
            deser.setConstructor(this.constructor);
        }
        return deser;
    }

    private Object readResolve() throws ObjectStreamException {
        return new SimpleListDeserializerFactory(this.clazzType, this.xmlType);
    }
}

