/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import org.apache.axis.session.Session;

public class AxisHttpSession
implements Session {
    public static final String AXIS_SESSION_MARKER = "axis.isAxisSession";
    private HttpSession rep;
    private HttpServletRequest req;

    public AxisHttpSession(HttpServletRequest realRequest) {
        this.req = realRequest;
    }

    public AxisHttpSession(HttpSession realSession) {
        if (realSession != null) {
            this.setRep(realSession);
        }
    }

    public HttpSession getRep() {
        this.ensureSession();
        return this.rep;
    }

    private void setRep(HttpSession realSession) {
        this.rep = realSession;
        this.rep.setAttribute(AXIS_SESSION_MARKER, (Object)Boolean.TRUE);
    }

    @Override
    public Object get(String key) {
        this.ensureSession();
        return this.rep.getAttribute(key);
    }

    @Override
    public void set(String key, Object value) {
        this.ensureSession();
        this.rep.setAttribute(key, value);
    }

    @Override
    public void remove(String key) {
        this.ensureSession();
        this.rep.removeAttribute(key);
    }

    @Override
    public Enumeration getKeys() {
        this.ensureSession();
        return this.rep.getAttributeNames();
    }

    @Override
    public void setTimeout(int timeout) {
        this.ensureSession();
        this.rep.setMaxInactiveInterval(timeout);
    }

    @Override
    public int getTimeout() {
        this.ensureSession();
        return this.rep.getMaxInactiveInterval();
    }

    @Override
    public void touch() {
    }

    @Override
    public void invalidate() {
        this.rep.invalidate();
    }

    protected void ensureSession() {
        if (this.rep == null) {
            this.setRep(this.req.getSession());
        }
    }

    @Override
    public Object getLockObject() {
        this.ensureSession();
        return this.rep;
    }
}

